# lbt01 functions with default argument value return expected result with test data

    Code
      cat(export_as_txt(res, lpp = 200))
    Output
      
      Parameter: Alanine Aminotransferase Measurement
      
        ———————————————————————————————————————————————————————————————————————————————————————
                                                          A: Drug X                B: Placebo  
                                                                 Change from                   
                                               Value at Visit      Baseline      Value at Visit
        Analysis Visit                             (N=15)           (N=15)           (N=15)    
        ———————————————————————————————————————————————————————————————————————————————————————
        BASELINE                                                                               
          n                                          15                                15      
          Mean (SD)                            20.262 (4.982)                    19.371 (4.687)
          Median                                   19.216                            19.781    
          Min - Max                            13.77 - 30.43                     11.58 - 25.59 
        WEEK 1 DAY 8                                                                           
          n                                          15               15               15      
          Mean (SD)                            19.227 (4.492)   -1.036 (7.113)   21.622 (3.015)
          Median                                   18.666           -2.148           21.790    
          Min - Max                            12.12 - 27.32    -12.07 - 9.07    16.69 - 26.32 
        WEEK 2 DAY 15                                                                          
          n                                          15               15               15      
          Mean (SD)                            19.458 (4.211)   -0.804 (6.309)   21.103 (3.831)
          Median                                   18.988           -2.571           20.200    
          Min - Max                            12.96 - 26.92    -12.00 - 13.14   13.42 - 29.93 
        WEEK 3 DAY 22                                                                          
          n                                          15               15               15      
          Mean (SD)                            19.795 (4.272)   -0.467 (6.304)   20.822 (3.234)
          Median                                   18.489           0.542            21.541    
          Min - Max                            13.51 - 26.07    -16.04 - 7.43    14.18 - 26.58 
        WEEK 4 DAY 29                                                                          
          n                                          15               15               15      
          Mean (SD)                            19.517 (3.640)   -0.745 (6.200)   19.824 (3.943)
          Median                                   17.927           1.239            19.875    
          Min - Max                            14.23 - 26.40    -13.17 - 7.57    13.56 - 26.43 
        WEEK 5 DAY 36                                                                          
          n                                          15               15               15      
          Mean (SD)                            19.952 (2.895)   -0.310 (6.188)   19.495 (3.459)
          Median                                   20.300           0.443            19.900    
          Min - Max                            14.40 - 24.56    -16.03 - 6.90    10.76 - 25.16 
      \s\n
      Parameter: Alanine Aminotransferase Measurement
      
        ———————————————————————————————————————————————————————————————————————————————————————
                                                 B: Placebo             C: Combination         
                                                Change from                       Change from  
                                                  Baseline      Value at Visit      Baseline   
        Analysis Visit                             (N=15)           (N=15)           (N=15)    
        ———————————————————————————————————————————————————————————————————————————————————————
        BASELINE                                                                               
          n                                                           15                       
          Mean (SD)                                             21.724 (3.857)                 
          Median                                                    22.900                     
          Min - Max                                             12.57 - 27.69                  
        WEEK 1 DAY 8                                                                           
          n                                          15               15               15      
          Mean (SD)                            2.251 (6.830)    20.630 (3.950)   -1.094 (4.425)
          Median                                   2.901            20.570           -0.398    
          Min - Max                            -6.73 - 14.36    13.21 - 27.31     -7.84 - 7.84 
        WEEK 2 DAY 15                                                                          
          n                                          15               15               15      
          Mean (SD)                            1.732 (5.981)    17.164 (3.089)   -4.559 (4.438)
          Median                                   2.499            16.740           -3.463    
          Min - Max                            -9.97 - 14.39    12.94 - 22.80    -10.95 - 1.01 
        WEEK 3 DAY 22                                                                          
          n                                          15               15               15      
          Mean (SD)                            1.451 (6.839)    20.165 (3.805)   -1.559 (4.042)
          Median                                   2.138            20.612           -2.878    
          Min - Max                            -9.21 - 15.00    14.01 - 25.74     -7.48 - 6.92 
        WEEK 4 DAY 29                                                                          
          n                                          15               15               15      
          Mean (SD)                            0.453 (5.486)    19.923 (5.026)   -1.801 (5.268)
          Median                                   -1.242           20.213           -1.254    
          Min - Max                             -6.52 - 8.87    11.32 - 26.59    -12.13 - 6.95 
        WEEK 5 DAY 36                                                                          
          n                                          15               15               15      
          Mean (SD)                            0.124 (6.533)    18.854 (3.392)   -2.869 (4.309)
          Median                                   0.822            19.358           -3.248    
          Min - Max                            -12.63 - 11.81   12.69 - 23.49    -11.07 - 6.79 
      \s\n
      Parameter: C-Reactive Protein Measurement
      
        ———————————————————————————————————————————————————————————————————————————————————————
                                                          A: Drug X                B: Placebo  
                                                                 Change from                   
                                               Value at Visit      Baseline      Value at Visit
        Analysis Visit                             (N=15)           (N=15)           (N=15)    
        ———————————————————————————————————————————————————————————————————————————————————————
        BASELINE                                                                               
          n                                          15                                15      
          Mean (SD)                            0.971 (0.246)                     1.026 (0.136) 
          Median                                   1.045                             1.073     
          Min - Max                             0.54 - 1.41                       0.73 - 1.19  
        WEEK 1 DAY 8                                                                           
          n                                          15               15               15      
          Mean (SD)                            1.042 (0.261)    0.072 (0.402)    1.025 (0.161) 
          Median                                   1.052            0.040            1.038     
          Min - Max                             0.58 - 1.57      -0.49 - 1.03     0.68 - 1.35  
        WEEK 2 DAY 15                                                                          
          n                                          15               15               15      
          Mean (SD)                            1.025 (0.268)    0.055 (0.286)    0.956 (0.228) 
          Median                                   1.026            0.048            0.973     
          Min - Max                             0.67 - 1.46      -0.34 - 0.57     0.59 - 1.32  
        WEEK 3 DAY 22                                                                          
          n                                          15               15               15      
          Mean (SD)                            1.006 (0.218)    0.035 (0.308)    0.954 (0.154) 
          Median                                   0.982            0.014            0.926     
          Min - Max                             0.61 - 1.43      -0.71 - 0.56     0.71 - 1.26  
        WEEK 4 DAY 29                                                                          
          n                                          15               15               15      
          Mean (SD)                            0.984 (0.185)    0.014 (0.303)    0.953 (0.233) 
          Median                                   1.006            -0.046           0.897     
          Min - Max                             0.70 - 1.25      -0.46 - 0.61     0.60 - 1.42  
        WEEK 5 DAY 36                                                                          
          n                                          15               15               15      
          Mean (SD)                            0.943 (0.186)    -0.028 (0.334)   0.989 (0.155) 
          Median                                   0.953            -0.065           0.960     
          Min - Max                             0.60 - 1.25      -0.81 - 0.71     0.71 - 1.29  
      \s\n
      Parameter: C-Reactive Protein Measurement
      
        ———————————————————————————————————————————————————————————————————————————————————————
                                                 B: Placebo             C: Combination         
                                                Change from                       Change from  
                                                  Baseline      Value at Visit      Baseline   
        Analysis Visit                             (N=15)           (N=15)           (N=15)    
        ———————————————————————————————————————————————————————————————————————————————————————
        BASELINE                                                                               
          n                                                           15                       
          Mean (SD)                                             0.995 (0.172)                  
          Median                                                    0.997                      
          Min - Max                                              0.64 - 1.32                   
        WEEK 1 DAY 8                                                                           
          n                                          15               15               15      
          Mean (SD)                            -0.001 (0.229)   0.972 (0.235)    -0.023 (0.312)
          Median                                   -0.001           0.983            -0.019    
          Min - Max                             -0.41 - 0.37     0.57 - 1.39      -0.39 - 0.75 
        WEEK 2 DAY 15                                                                          
          n                                          15               15               15      
          Mean (SD)                            -0.070 (0.229)   1.010 (0.189)    0.015 (0.255) 
          Median                                   -0.100           0.983            -0.066    
          Min - Max                             -0.40 - 0.26     0.67 - 1.37      -0.28 - 0.50 
        WEEK 3 DAY 22                                                                          
          n                                          15               15               15      
          Mean (SD)                            -0.072 (0.191)   1.036 (0.162)    0.042 (0.267) 
          Median                                   -0.050           1.061            0.021     
          Min - Max                             -0.44 - 0.25     0.81 - 1.33      -0.45 - 0.45 
        WEEK 4 DAY 29                                                                          
          n                                          15               15               15      
          Mean (SD)                            -0.073 (0.291)   1.032 (0.198)    0.038 (0.337) 
          Median                                   -0.157           0.959            -0.043    
          Min - Max                             -0.41 - 0.59     0.80 - 1.46      -0.51 - 0.82 
        WEEK 5 DAY 36                                                                          
          n                                          15               15               15      
          Mean (SD)                            -0.037 (0.226)   0.956 (0.158)    -0.039 (0.220)
          Median                                   -0.099           0.993            -0.049    
          Min - Max                             -0.36 - 0.56     0.66 - 1.26      -0.44 - 0.34 
      \s\n
      Parameter: Immunoglobulin A Measurement
      
        ———————————————————————————————————————————————————————————————————————————————————————
                                                          A: Drug X                B: Placebo  
                                                                 Change from                   
                                               Value at Visit      Baseline      Value at Visit
        Analysis Visit                             (N=15)           (N=15)           (N=15)    
        ———————————————————————————————————————————————————————————————————————————————————————
        BASELINE                                                                               
          n                                          15                                15      
          Mean (SD)                            1.843 (0.341)                     2.074 (0.452) 
          Median                                   1.815                             1.978     
          Min - Max                             1.32 - 2.76                       1.25 - 2.95  
        WEEK 1 DAY 8                                                                           
          n                                          15               15               15      
          Mean (SD)                            2.029 (0.343)    0.186 (0.561)    2.261 (0.422) 
          Median                                   1.979            0.257            2.288     
          Min - Max                             1.56 - 2.67      -1.10 - 1.08     1.54 - 3.02  
        WEEK 2 DAY 15                                                                          
          n                                          15               15               15      
          Mean (SD)                            2.006 (0.361)    0.163 (0.559)    2.010 (0.332) 
          Median                                   1.944            0.140            2.051     
          Min - Max                             1.59 - 2.88      -0.84 - 1.04     1.25 - 2.55  
        WEEK 3 DAY 22                                                                          
          n                                          15               15               15      
          Mean (SD)                            2.001 (0.382)    0.158 (0.468)    2.001 (0.500) 
          Median                                   1.958            0.214            2.174     
          Min - Max                             1.34 - 2.80      -0.80 - 0.94     0.75 - 2.68  
        WEEK 4 DAY 29                                                                          
          n                                          15               15               15      
          Mean (SD)                            1.988 (0.231)    0.145 (0.445)    1.697 (0.404) 
          Median                                   2.080            0.081            1.697     
          Min - Max                             1.44 - 2.25      -0.87 - 0.88     1.10 - 2.43  
        WEEK 5 DAY 36                                                                          
          n                                          15               15               15      
          Mean (SD)                            2.087 (0.179)    0.243 (0.397)    1.935 (0.442) 
          Median                                   2.102            0.379            1.832     
          Min - Max                             1.81 - 2.41      -0.81 - 0.78     1.33 - 2.72  
      \s\n
      Parameter: Immunoglobulin A Measurement
      
        ———————————————————————————————————————————————————————————————————————————————————————
                                                 B: Placebo             C: Combination         
                                                Change from                       Change from  
                                                  Baseline      Value at Visit      Baseline   
        Analysis Visit                             (N=15)           (N=15)           (N=15)    
        ———————————————————————————————————————————————————————————————————————————————————————
        BASELINE                                                                               
          n                                                           15                       
          Mean (SD)                                             1.890 (0.486)                  
          Median                                                    1.750                      
          Min - Max                                              1.15 - 2.65                   
        WEEK 1 DAY 8                                                                           
          n                                          15               15               15      
          Mean (SD)                            0.187 (0.565)    1.884 (0.430)    -0.006 (0.738)
          Median                                   0.284            1.832            -0.099    
          Min - Max                             -0.85 - 1.05     1.07 - 2.52      -1.44 - 1.14 
        WEEK 2 DAY 15                                                                          
          n                                          15               15               15      
          Mean (SD)                            -0.064 (0.368)   1.944 (0.325)    0.054 (0.597) 
          Median                                   -0.045           1.976            0.171     
          Min - Max                             -0.83 - 0.57     1.32 - 2.52      -0.79 - 0.95 
        WEEK 3 DAY 22                                                                          
          n                                          15               15               15      
          Mean (SD)                            -0.073 (0.572)   2.040 (0.389)    0.150 (0.578) 
          Median                                   -0.022           2.068            -0.030    
          Min - Max                             -1.13 - 0.96     1.37 - 2.70      -0.57 - 1.17 
        WEEK 4 DAY 29                                                                          
          n                                          15               15               15      
          Mean (SD)                            -0.377 (0.605)   2.113 (0.432)    0.223 (0.828) 
          Median                                   -0.284           2.240            0.583     
          Min - Max                             -1.32 - 0.90     1.31 - 2.68      -1.02 - 1.50 
        WEEK 5 DAY 36                                                                          
          n                                          15               15               15      
          Mean (SD)                            -0.139 (0.636)   1.933 (0.386)    0.043 (0.662) 
          Median                                   -0.176           1.924            0.100     
          Min - Max                             -1.17 - 0.85     1.11 - 2.55      -1.23 - 1.15 

# lbt01 functions with row_split_var return expected result with test data

    Code
      cat(export_as_txt(res, lpp = 200))
    Output
      
      Category for Lab Test: CHEMISTRY
      Parameter: Alanine Aminotransferase Measurement
      
        —————————————————————————————————————————————————————————————————————————————————————————
                                                            A: Drug X                B: Placebo  
                                                                   Change from                   
                                                 Value at Visit      Baseline      Value at Visit
        Analysis Visit                               (N=15)           (N=15)           (N=15)    
        —————————————————————————————————————————————————————————————————————————————————————————
        BASELINE                                                                                 
          n                                            15                                15      
          Mean (SD)                              20.262 (4.982)                    19.371 (4.687)
          Median                                     19.216                            19.781    
          Min - Max                              13.77 - 30.43                     11.58 - 25.59 
        WEEK 1 DAY 8                                                                             
          n                                            15               15               15      
          Mean (SD)                              19.227 (4.492)   -1.036 (7.113)   21.622 (3.015)
          Median                                     18.666           -2.148           21.790    
          Min - Max                              12.12 - 27.32    -12.07 - 9.07    16.69 - 26.32 
        WEEK 2 DAY 15                                                                            
          n                                            15               15               15      
          Mean (SD)                              19.458 (4.211)   -0.804 (6.309)   21.103 (3.831)
          Median                                     18.988           -2.571           20.200    
          Min - Max                              12.96 - 26.92    -12.00 - 13.14   13.42 - 29.93 
        WEEK 3 DAY 22                                                                            
          n                                            15               15               15      
          Mean (SD)                              19.795 (4.272)   -0.467 (6.304)   20.822 (3.234)
          Median                                     18.489           0.542            21.541    
          Min - Max                              13.51 - 26.07    -16.04 - 7.43    14.18 - 26.58 
        WEEK 4 DAY 29                                                                            
          n                                            15               15               15      
          Mean (SD)                              19.517 (3.640)   -0.745 (6.200)   19.824 (3.943)
          Median                                     17.927           1.239            19.875    
          Min - Max                              14.23 - 26.40    -13.17 - 7.57    13.56 - 26.43 
        WEEK 5 DAY 36                                                                            
          n                                            15               15               15      
          Mean (SD)                              19.952 (2.895)   -0.310 (6.188)   19.495 (3.459)
          Median                                     20.300           0.443            19.900    
          Min - Max                              14.40 - 24.56    -16.03 - 6.90    10.76 - 25.16 
      \s\n
      Category for Lab Test: CHEMISTRY
      Parameter: Alanine Aminotransferase Measurement
      
        —————————————————————————————————————————————————————————————————————————————————————————
                                                   B: Placebo             C: Combination         
                                                  Change from                       Change from  
                                                    Baseline      Value at Visit      Baseline   
        Analysis Visit                               (N=15)           (N=15)           (N=15)    
        —————————————————————————————————————————————————————————————————————————————————————————
        BASELINE                                                                                 
          n                                                             15                       
          Mean (SD)                                               21.724 (3.857)                 
          Median                                                      22.900                     
          Min - Max                                               12.57 - 27.69                  
        WEEK 1 DAY 8                                                                             
          n                                            15               15               15      
          Mean (SD)                              2.251 (6.830)    20.630 (3.950)   -1.094 (4.425)
          Median                                     2.901            20.570           -0.398    
          Min - Max                              -6.73 - 14.36    13.21 - 27.31     -7.84 - 7.84 
        WEEK 2 DAY 15                                                                            
          n                                            15               15               15      
          Mean (SD)                              1.732 (5.981)    17.164 (3.089)   -4.559 (4.438)
          Median                                     2.499            16.740           -3.463    
          Min - Max                              -9.97 - 14.39    12.94 - 22.80    -10.95 - 1.01 
        WEEK 3 DAY 22                                                                            
          n                                            15               15               15      
          Mean (SD)                              1.451 (6.839)    20.165 (3.805)   -1.559 (4.042)
          Median                                     2.138            20.612           -2.878    
          Min - Max                              -9.21 - 15.00    14.01 - 25.74     -7.48 - 6.92 
        WEEK 4 DAY 29                                                                            
          n                                            15               15               15      
          Mean (SD)                              0.453 (5.486)    19.923 (5.026)   -1.801 (5.268)
          Median                                     -1.242           20.213           -1.254    
          Min - Max                               -6.52 - 8.87    11.32 - 26.59    -12.13 - 6.95 
        WEEK 5 DAY 36                                                                            
          n                                            15               15               15      
          Mean (SD)                              0.124 (6.533)    18.854 (3.392)   -2.869 (4.309)
          Median                                     0.822            19.358           -3.248    
          Min - Max                              -12.63 - 11.81   12.69 - 23.49    -11.07 - 6.79 
      \s\n
      Category for Lab Test: CHEMISTRY
      Parameter: C-Reactive Protein Measurement
      
        —————————————————————————————————————————————————————————————————————————————————————————
                                                            A: Drug X                B: Placebo  
                                                                   Change from                   
                                                 Value at Visit      Baseline      Value at Visit
        Analysis Visit                               (N=15)           (N=15)           (N=15)    
        —————————————————————————————————————————————————————————————————————————————————————————
        BASELINE                                                                                 
          n                                            15                                15      
          Mean (SD)                              0.971 (0.246)                     1.026 (0.136) 
          Median                                     1.045                             1.073     
          Min - Max                               0.54 - 1.41                       0.73 - 1.19  
        WEEK 1 DAY 8                                                                             
          n                                            15               15               15      
          Mean (SD)                              1.042 (0.261)    0.072 (0.402)    1.025 (0.161) 
          Median                                     1.052            0.040            1.038     
          Min - Max                               0.58 - 1.57      -0.49 - 1.03     0.68 - 1.35  
        WEEK 2 DAY 15                                                                            
          n                                            15               15               15      
          Mean (SD)                              1.025 (0.268)    0.055 (0.286)    0.956 (0.228) 
          Median                                     1.026            0.048            0.973     
          Min - Max                               0.67 - 1.46      -0.34 - 0.57     0.59 - 1.32  
        WEEK 3 DAY 22                                                                            
          n                                            15               15               15      
          Mean (SD)                              1.006 (0.218)    0.035 (0.308)    0.954 (0.154) 
          Median                                     0.982            0.014            0.926     
          Min - Max                               0.61 - 1.43      -0.71 - 0.56     0.71 - 1.26  
        WEEK 4 DAY 29                                                                            
          n                                            15               15               15      
          Mean (SD)                              0.984 (0.185)    0.014 (0.303)    0.953 (0.233) 
          Median                                     1.006            -0.046           0.897     
          Min - Max                               0.70 - 1.25      -0.46 - 0.61     0.60 - 1.42  
        WEEK 5 DAY 36                                                                            
          n                                            15               15               15      
          Mean (SD)                              0.943 (0.186)    -0.028 (0.334)   0.989 (0.155) 
          Median                                     0.953            -0.065           0.960     
          Min - Max                               0.60 - 1.25      -0.81 - 0.71     0.71 - 1.29  
      \s\n
      Category for Lab Test: CHEMISTRY
      Parameter: C-Reactive Protein Measurement
      
        —————————————————————————————————————————————————————————————————————————————————————————
                                                   B: Placebo             C: Combination         
                                                  Change from                       Change from  
                                                    Baseline      Value at Visit      Baseline   
        Analysis Visit                               (N=15)           (N=15)           (N=15)    
        —————————————————————————————————————————————————————————————————————————————————————————
        BASELINE                                                                                 
          n                                                             15                       
          Mean (SD)                                               0.995 (0.172)                  
          Median                                                      0.997                      
          Min - Max                                                0.64 - 1.32                   
        WEEK 1 DAY 8                                                                             
          n                                            15               15               15      
          Mean (SD)                              -0.001 (0.229)   0.972 (0.235)    -0.023 (0.312)
          Median                                     -0.001           0.983            -0.019    
          Min - Max                               -0.41 - 0.37     0.57 - 1.39      -0.39 - 0.75 
        WEEK 2 DAY 15                                                                            
          n                                            15               15               15      
          Mean (SD)                              -0.070 (0.229)   1.010 (0.189)    0.015 (0.255) 
          Median                                     -0.100           0.983            -0.066    
          Min - Max                               -0.40 - 0.26     0.67 - 1.37      -0.28 - 0.50 
        WEEK 3 DAY 22                                                                            
          n                                            15               15               15      
          Mean (SD)                              -0.072 (0.191)   1.036 (0.162)    0.042 (0.267) 
          Median                                     -0.050           1.061            0.021     
          Min - Max                               -0.44 - 0.25     0.81 - 1.33      -0.45 - 0.45 
        WEEK 4 DAY 29                                                                            
          n                                            15               15               15      
          Mean (SD)                              -0.073 (0.291)   1.032 (0.198)    0.038 (0.337) 
          Median                                     -0.157           0.959            -0.043    
          Min - Max                               -0.41 - 0.59     0.80 - 1.46      -0.51 - 0.82 
        WEEK 5 DAY 36                                                                            
          n                                            15               15               15      
          Mean (SD)                              -0.037 (0.226)   0.956 (0.158)    -0.039 (0.220)
          Median                                     -0.099           0.993            -0.049    
          Min - Max                               -0.36 - 0.56     0.66 - 1.26      -0.44 - 0.34 
      \s\n
      Category for Lab Test: IMMUNOLOGY
      Parameter: Immunoglobulin A Measurement
      
        —————————————————————————————————————————————————————————————————————————————————————————
                                                            A: Drug X                B: Placebo  
                                                                   Change from                   
                                                 Value at Visit      Baseline      Value at Visit
        Analysis Visit                               (N=15)           (N=15)           (N=15)    
        —————————————————————————————————————————————————————————————————————————————————————————
        BASELINE                                                                                 
          n                                            15                                15      
          Mean (SD)                              1.843 (0.341)                     2.074 (0.452) 
          Median                                     1.815                             1.978     
          Min - Max                               1.32 - 2.76                       1.25 - 2.95  
        WEEK 1 DAY 8                                                                             
          n                                            15               15               15      
          Mean (SD)                              2.029 (0.343)    0.186 (0.561)    2.261 (0.422) 
          Median                                     1.979            0.257            2.288     
          Min - Max                               1.56 - 2.67      -1.10 - 1.08     1.54 - 3.02  
        WEEK 2 DAY 15                                                                            
          n                                            15               15               15      
          Mean (SD)                              2.006 (0.361)    0.163 (0.559)    2.010 (0.332) 
          Median                                     1.944            0.140            2.051     
          Min - Max                               1.59 - 2.88      -0.84 - 1.04     1.25 - 2.55  
        WEEK 3 DAY 22                                                                            
          n                                            15               15               15      
          Mean (SD)                              2.001 (0.382)    0.158 (0.468)    2.001 (0.500) 
          Median                                     1.958            0.214            2.174     
          Min - Max                               1.34 - 2.80      -0.80 - 0.94     0.75 - 2.68  
        WEEK 4 DAY 29                                                                            
          n                                            15               15               15      
          Mean (SD)                              1.988 (0.231)    0.145 (0.445)    1.697 (0.404) 
          Median                                     2.080            0.081            1.697     
          Min - Max                               1.44 - 2.25      -0.87 - 0.88     1.10 - 2.43  
        WEEK 5 DAY 36                                                                            
          n                                            15               15               15      
          Mean (SD)                              2.087 (0.179)    0.243 (0.397)    1.935 (0.442) 
          Median                                     2.102            0.379            1.832     
          Min - Max                               1.81 - 2.41      -0.81 - 0.78     1.33 - 2.72  
      \s\n
      Category for Lab Test: IMMUNOLOGY
      Parameter: Immunoglobulin A Measurement
      
        —————————————————————————————————————————————————————————————————————————————————————————
                                                   B: Placebo             C: Combination         
                                                  Change from                       Change from  
                                                    Baseline      Value at Visit      Baseline   
        Analysis Visit                               (N=15)           (N=15)           (N=15)    
        —————————————————————————————————————————————————————————————————————————————————————————
        BASELINE                                                                                 
          n                                                             15                       
          Mean (SD)                                               1.890 (0.486)                  
          Median                                                      1.750                      
          Min - Max                                                1.15 - 2.65                   
        WEEK 1 DAY 8                                                                             
          n                                            15               15               15      
          Mean (SD)                              0.187 (0.565)    1.884 (0.430)    -0.006 (0.738)
          Median                                     0.284            1.832            -0.099    
          Min - Max                               -0.85 - 1.05     1.07 - 2.52      -1.44 - 1.14 
        WEEK 2 DAY 15                                                                            
          n                                            15               15               15      
          Mean (SD)                              -0.064 (0.368)   1.944 (0.325)    0.054 (0.597) 
          Median                                     -0.045           1.976            0.171     
          Min - Max                               -0.83 - 0.57     1.32 - 2.52      -0.79 - 0.95 
        WEEK 3 DAY 22                                                                            
          n                                            15               15               15      
          Mean (SD)                              -0.073 (0.572)   2.040 (0.389)    0.150 (0.578) 
          Median                                     -0.022           2.068            -0.030    
          Min - Max                               -1.13 - 0.96     1.37 - 2.70      -0.57 - 1.17 
        WEEK 4 DAY 29                                                                            
          n                                            15               15               15      
          Mean (SD)                              -0.377 (0.605)   2.113 (0.432)    0.223 (0.828) 
          Median                                     -0.284           2.240            0.583     
          Min - Max                               -1.32 - 0.90     1.31 - 2.68      -1.02 - 1.50 
        WEEK 5 DAY 36                                                                            
          n                                            15               15               15      
          Mean (SD)                              -0.139 (0.636)   1.933 (0.386)    0.043 (0.662) 
          Median                                     -0.176           1.924            0.100     
          Min - Max                               -1.17 - 0.85     1.11 - 2.55      -1.23 - 1.15 

# lbt01 can handle n = 0 and outputs NE instead of infs and NAs

    Code
      cat(export_as_txt(res, lpp = 200))
    Output
      
      Parameter: Alanine Aminotransferase Measurement
      
        ——————————————————————————————————————————————————————————————————————————————————————————————————————
                                                         A: Drug X                       B: Placebo           
                                                                Change from                      Change from  
                                               Value at Visit     Baseline     Value at Visit      Baseline   
        Analysis Visit                             (N=15)          (N=15)          (N=15)           (N=15)    
        ——————————————————————————————————————————————————————————————————————————————————————————————————————
        BASELINE                                                                                              
          n                                          0                               15                       
          Mean (SD)                               NE (NE)                        19.4 (4.7)                   
          Median                                     NE                             19.8                      
          Min - Max                               NE - NE                         12 - 26                     
        WEEK 1 DAY 8                                                                                          
          n                                          0               0               15               15      
          Mean (SD)                               NE (NE)         NE (NE)        21.6 (3.0)       2.3 (6.8)   
          Median                                     NE              NE             21.8             2.9      
          Min - Max                               NE - NE         NE - NE         17 - 26          -7 - 14    
        WEEK 2 DAY 15                                                                                         
          n                                          0               0               15               15      
          Mean (SD)                               NE (NE)         NE (NE)        21.1 (3.8)       1.7 (6.0)   
          Median                                     NE              NE             20.2             2.5      
          Min - Max                               NE - NE         NE - NE         13 - 30          -10 - 14   
        WEEK 3 DAY 22                                                                                         
          n                                          0               0               15               15      
          Mean (SD)                               NE (NE)         NE (NE)        20.8 (3.2)       1.5 (6.8)   
          Median                                     NE              NE             21.5             2.1      
          Min - Max                               NE - NE         NE - NE         14 - 27          -9 - 15    
        WEEK 4 DAY 29                                                                                         
          n                                          0               0               15               15      
          Mean (SD)                               NE (NE)         NE (NE)        19.8 (3.9)       0.5 (5.5)   
          Median                                     NE              NE             19.9             -1.2     
          Min - Max                               NE - NE         NE - NE         14 - 26           -7 - 9    
        WEEK 5 DAY 36                                                                                         
          n                                          0               0               15               15      
          Mean (SD)                               NE (NE)         NE (NE)        19.5 (3.5)       0.1 (6.5)   
          Median                                     NE              NE             19.9             0.8      
          Min - Max                               NE - NE         NE - NE         11 - 25          -13 - 12   
      \s\n
      Parameter: Alanine Aminotransferase Measurement
      
        ——————————————————————————————————————————————————————————————————————
                                                       C: Combination         
                                                                 Change from  
                                               Value at Visit      Baseline   
        Analysis Visit                             (N=15)           (N=15)    
        ——————————————————————————————————————————————————————————————————————
        BASELINE                                                              
          n                                          15                       
          Mean (SD)                              21.7 (3.9)                   
          Median                                    22.9                      
          Min - Max                               13 - 28                     
        WEEK 1 DAY 8                                                          
          n                                          15               15      
          Mean (SD)                              20.6 (4.0)       -1.1 (4.4)  
          Median                                    20.6             -0.4     
          Min - Max                               13 - 27           -8 - 8    
        WEEK 2 DAY 15                                                         
          n                                          15               15      
          Mean (SD)                              17.2 (3.1)       -4.6 (4.4)  
          Median                                    16.7             -3.5     
          Min - Max                               13 - 23          -11 - 1    
        WEEK 3 DAY 22                                                         
          n                                          15               15      
          Mean (SD)                              20.2 (3.8)       -1.6 (4.0)  
          Median                                    20.6             -2.9     
          Min - Max                               14 - 26           -7 - 7    
        WEEK 4 DAY 29                                                         
          n                                          15               15      
          Mean (SD)                              19.9 (5.0)       -1.8 (5.3)  
          Median                                    20.2             -1.3     
          Min - Max                               11 - 27          -12 - 7    
        WEEK 5 DAY 36                                                         
          n                                          15               15      
          Mean (SD)                              18.9 (3.4)       -2.9 (4.3)  
          Median                                    19.4             -3.2     
          Min - Max                               13 - 23          -11 - 7    
      \s\n
      Parameter: C-Reactive Protein Measurement
      
        ——————————————————————————————————————————————————————————————————————————————————————————————————————
                                                         A: Drug X                       B: Placebo           
                                                                Change from                      Change from  
                                               Value at Visit     Baseline     Value at Visit      Baseline   
        Analysis Visit                             (N=15)          (N=15)          (N=15)           (N=15)    
        ——————————————————————————————————————————————————————————————————————————————————————————————————————
        BASELINE                                                                                              
          n                                          0                               15                       
          Mean (SD)                               NE (NE)                       1.03 (0.14)                   
          Median                                     NE                             1.07                      
          Min - Max                               NE - NE                        0.7 - 1.2                    
        WEEK 1 DAY 8                                                                                          
          n                                          0               0               15               15      
          Mean (SD)                               NE (NE)         NE (NE)       1.03 (0.16)      -0.00 (0.23) 
          Median                                     NE              NE             1.04            -0.00     
          Min - Max                               NE - NE         NE - NE        0.7 - 1.3        -0.4 - 0.4  
        WEEK 2 DAY 15                                                                                         
          n                                          0               0               15               15      
          Mean (SD)                               NE (NE)         NE (NE)       0.96 (0.23)      -0.07 (0.23) 
          Median                                     NE              NE             0.97            -0.10     
          Min - Max                               NE - NE         NE - NE        0.6 - 1.3        -0.4 - 0.3  
        WEEK 3 DAY 22                                                                                         
          n                                          0               0               15               15      
          Mean (SD)                               NE (NE)         NE (NE)       0.95 (0.15)      -0.07 (0.19) 
          Median                                     NE              NE             0.93            -0.05     
          Min - Max                               NE - NE         NE - NE        0.7 - 1.3        -0.4 - 0.3  
        WEEK 4 DAY 29                                                                                         
          n                                          0               0               15               15      
          Mean (SD)                               NE (NE)         NE (NE)       0.95 (0.23)      -0.07 (0.29) 
          Median                                     NE              NE             0.90            -0.16     
          Min - Max                               NE - NE         NE - NE        0.6 - 1.4        -0.4 - 0.6  
        WEEK 5 DAY 36                                                                                         
          n                                          0               0               15               15      
          Mean (SD)                               NE (NE)         NE (NE)       0.99 (0.15)      -0.04 (0.23) 
          Median                                     NE              NE             0.96            -0.10     
          Min - Max                               NE - NE         NE - NE        0.7 - 1.3        -0.4 - 0.6  
      \s\n
      Parameter: C-Reactive Protein Measurement
      
        ——————————————————————————————————————————————————————————————————————
                                                       C: Combination         
                                                                 Change from  
                                               Value at Visit      Baseline   
        Analysis Visit                             (N=15)           (N=15)    
        ——————————————————————————————————————————————————————————————————————
        BASELINE                                                              
          n                                          15                       
          Mean (SD)                             0.99 (0.17)                   
          Median                                    1.00                      
          Min - Max                              0.6 - 1.3                    
        WEEK 1 DAY 8                                                          
          n                                          15               15      
          Mean (SD)                             0.97 (0.24)      -0.02 (0.31) 
          Median                                    0.98            -0.02     
          Min - Max                              0.6 - 1.4        -0.4 - 0.8  
        WEEK 2 DAY 15                                                         
          n                                          15               15      
          Mean (SD)                             1.01 (0.19)      0.02 (0.25)  
          Median                                    0.98            -0.07     
          Min - Max                              0.7 - 1.4        -0.3 - 0.5  
        WEEK 3 DAY 22                                                         
          n                                          15               15      
          Mean (SD)                             1.04 (0.16)      0.04 (0.27)  
          Median                                    1.06             0.02     
          Min - Max                              0.8 - 1.3        -0.4 - 0.4  
        WEEK 4 DAY 29                                                         
          n                                          15               15      
          Mean (SD)                             1.03 (0.20)      0.04 (0.34)  
          Median                                    0.96            -0.04     
          Min - Max                              0.8 - 1.5        -0.5 - 0.8  
        WEEK 5 DAY 36                                                         
          n                                          15               15      
          Mean (SD)                             0.96 (0.16)      -0.04 (0.22) 
          Median                                    0.99            -0.05     
          Min - Max                              0.7 - 1.3        -0.4 - 0.3  
      \s\n
      Parameter: Immunoglobulin A Measurement
      
        ——————————————————————————————————————————————————————————————————————————————————————————————————————
                                                         A: Drug X                       B: Placebo           
                                                                Change from                      Change from  
                                               Value at Visit     Baseline     Value at Visit      Baseline   
        Analysis Visit                             (N=15)          (N=15)          (N=15)           (N=15)    
        ——————————————————————————————————————————————————————————————————————————————————————————————————————
        BASELINE                                                                                              
          n                                          0                               15                       
          Mean (SD)                               NE (NE)                      2.074 (0.452)                  
          Median                                     NE                            1.978                      
          Min - Max                               NE - NE                       1.25 - 2.95                   
        WEEK 1 DAY 8                                                                                          
          n                                          0               0               15               15      
          Mean (SD)                               NE (NE)         NE (NE)      2.261 (0.422)    0.187 (0.565) 
          Median                                     NE              NE            2.288            0.284     
          Min - Max                               NE - NE         NE - NE       1.54 - 3.02      -0.85 - 1.05 
        WEEK 2 DAY 15                                                                                         
          n                                          0               0               15               15      
          Mean (SD)                               NE (NE)         NE (NE)      2.010 (0.332)    -0.064 (0.368)
          Median                                     NE              NE            2.051            -0.045    
          Min - Max                               NE - NE         NE - NE       1.25 - 2.55      -0.83 - 0.57 
        WEEK 3 DAY 22                                                                                         
          n                                          0               0               15               15      
          Mean (SD)                               NE (NE)         NE (NE)      2.001 (0.500)    -0.073 (0.572)
          Median                                     NE              NE            2.174            -0.022    
          Min - Max                               NE - NE         NE - NE       0.75 - 2.68      -1.13 - 0.96 
        WEEK 4 DAY 29                                                                                         
          n                                          0               0               15               15      
          Mean (SD)                               NE (NE)         NE (NE)      1.697 (0.404)    -0.377 (0.605)
          Median                                     NE              NE            1.697            -0.284    
          Min - Max                               NE - NE         NE - NE       1.10 - 2.43      -1.32 - 0.90 
        WEEK 5 DAY 36                                                                                         
          n                                          0               0               15               15      
          Mean (SD)                               NE (NE)         NE (NE)      1.935 (0.442)    -0.139 (0.636)
          Median                                     NE              NE            1.832            -0.176    
          Min - Max                               NE - NE         NE - NE       1.33 - 2.72      -1.17 - 0.85 
      \s\n
      Parameter: Immunoglobulin A Measurement
      
        ——————————————————————————————————————————————————————————————————————
                                                       C: Combination         
                                                                 Change from  
                                               Value at Visit      Baseline   
        Analysis Visit                             (N=15)           (N=15)    
        ——————————————————————————————————————————————————————————————————————
        BASELINE                                                              
          n                                          15                       
          Mean (SD)                            1.890 (0.486)                  
          Median                                   1.750                      
          Min - Max                             1.15 - 2.65                   
        WEEK 1 DAY 8                                                          
          n                                          15               15      
          Mean (SD)                            1.884 (0.430)    -0.006 (0.738)
          Median                                   1.832            -0.099    
          Min - Max                             1.07 - 2.52      -1.44 - 1.14 
        WEEK 2 DAY 15                                                         
          n                                          15               15      
          Mean (SD)                            1.944 (0.325)    0.054 (0.597) 
          Median                                   1.976            0.171     
          Min - Max                             1.32 - 2.52      -0.79 - 0.95 
        WEEK 3 DAY 22                                                         
          n                                          15               15      
          Mean (SD)                            2.040 (0.389)    0.150 (0.578) 
          Median                                   2.068            -0.030    
          Min - Max                             1.37 - 2.70      -0.57 - 1.17 
        WEEK 4 DAY 29                                                         
          n                                          15               15      
          Mean (SD)                            2.113 (0.432)    0.223 (0.828) 
          Median                                   2.240            0.583     
          Min - Max                             1.31 - 2.68      -1.02 - 1.50 
        WEEK 5 DAY 36                                                         
          n                                          15               15      
          Mean (SD)                            1.933 (0.386)    0.043 (0.662) 
          Median                                   1.924            0.100     
          Min - Max                             1.11 - 2.55      -1.23 - 1.15 

