% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimSigma.R
\name{EstimSigma}
\alias{EstimSigma}
\title{Data variance estimation}
\usage{
EstimSigma(
  Data,
  ind.col,
  m,
  nblocks = 32,
  niter = 3,
  sigma_start = 0.1,
  nparts = 1,
  ...
)
}
\arguments{
\item{Data}{A Filebacked Big Matrix n x N. Data signals are stored in the matrix columns.}

\item{ind.col}{Column indeces for which the data sketch is computed. By default all matrix columns.}

\item{m}{Number of frequency vectors.}

\item{nblocks}{Number of blocks, on which the regression is performed. Default is 32.}

\item{niter}{Number of iterations. Default is 3.}

\item{sigma_start}{An initial value of the data variance. Default is 0.1.}

\item{nparts}{Number of parts to split the data for the data sketch computation.}

\item{...}{Additional arguments passed on to \code{\link{DrawFreq}} function.}
}
\value{
The estimated data variance.
}
\description{
The mean data variance estimation.
}
\note{
The idea of the variance estimation on the data fraction is taken from \insertRef{DBLP:journals/corr/KerivenBGP16}{chickn}.
}
\examples{
X = matrix(rnorm(1e5), ncol=1000, nrow = 100)
X_FBM = bigstatsr::FBM(init = X, ncol=1000, nrow = 100)
sigma = EstimSigma(Data = X_FBM, ind.col = seq(1,1000, by = 2), m = 20, nblocks = 4)  
}
\seealso{
\code{\link{DrawFreq}}, \code{\link{Sketch}}, \code{\link{GenerateFrequencies}}
}
