#' LMS Parameters for the Centers for Disease Control and Prevention
#' 2000 Growth Charts, contains bmi, height, head cirumference, weight,
#' weight for length, 
#' @name cdc.ref
#' @docType data
#' @usage cdc.ref
#' @source National health statitics reports 63.
NULL

#' LMS Parameters for German reference data (KiGGS, 2003-2006)
#' for height, weight, bmi, hip, whr, bodyfat, skinfold sum, triceps
#' skinfold, and waist circumference
#' @name kiggs.ref 
#' @docType data
#' @usage kiggs.ref
#' @source Referenzperzentile fuer anthropometrische Masszahlen und Blutdruck aus KiGGS 2003-2006, Robert Koch Institut, Germany
NULL


#' LMS Parameters for German reference data (Kromeyer Hauschild, 2001)
#' for height, weight, bmi, and waist circumference, including preterm
#' correction (Voigt)
#' @name kro.ref
#' @docType data
#' @usage kro.ref
#' @source Perzentile fuer den Body-mass-Index fuer das Kindes- und Jugendalter unter Heranziehung verschiedener deutscher Stichproben, Monatsschrift Kinderheilkunde August 2001, Volume 149, Issue 8, pp 807-818; Fruehgeborenenkorrektur nach Voigt
NULL

#' LMS Parameters for UK-WHO growth charts for height,
#' weight, bmi, head circumference
#' @name ukwho.ref
#' @docType data
#' @usage ukwho.ref
#' @source Wright, Charlotte M., et a,Practice pointer: Using the new UK-WHO growth charts. British Medical Journal 340.c1140 (2010): 647-650.Preterm British 1990, 0-4 WHO2006, 4-18 British1990
NULL


#' LMS Parameters for UK-WHO growth charts for height, weight, bmi,
#' head circumference,arm mid upper arm circumference, subscapular
#' and triceps skinfold, weight for height
#' @name who.ref
#' @docType data
#' @usage who.ref
#' @source de Onis, M., Onyango, A., Borghi, E., Siyam, A., Blossner, M., & Lutter, C. (2012). Worldwide implementation of the WHO child growth standards. Public Health Nutr, 12, 1-8.
NULL


#' Parameters for iron-related blood parameters in children
#' @name iron.ref
#' @docType data
#' @usage iron.ref
#' @source Rieger, K. et al. Reference intervals for iron-related blood parameters: results from a population-based cohort study (LIFE Child). LaboratoriumsMedizin 40, (2016).
NULL


#' Parameters for serum lipids in children
#' @name lipids.ref
#' @docType data
#' @usage lipids.ref
#' @source Dathan-Stumpf, A. et al. Pediatric reference data of serum lipids and prevalence of dyslipidemia: Results from a population-based cohort in Germany. Clinical Biochemistry 49, 740–749 (2016).
NULL
