% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_common_string.R
\name{identify_common_string}
\alias{identify_common_string}
\title{Identify shared leading or trailing character strings}
\usage{
identify_common_string(strings, leading = TRUE)
}
\arguments{
\item{strings}{vector of strings to be evaluated.}

\item{leading}{boolean variable indicating whether the function should look for common strings at the beginning
(leading==TRUE) or end (leading==FALSE) of the strings. Default is TRUE.}
}
\value{
if there is a leading (if leading==TRUE) or trailing (if leading==FALSE) string that all elements of
strings have in common, this string is returned; NA otherwise.
}
\description{
Compares all elements of a vector of numbers or character strings and returns TRUE
if they are all the same, FALSE otherwise.
}
\examples{

  identify_common_string(c("Temp_01","Temp_02","Temp_03"))
  identify_common_string(c("Temp_01","Temp_02","Temp_03"),leading=FALSE)
  identify_common_string(c("file1.csv","file2.csv","file3.csv"),leading=FALSE)
    
}
\author{
Eike Luedeling
}
\keyword{utility}

