% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getClimateWizardData.R
\name{getClimateWizardData}
\alias{getClimateWizardData}
\title{Extract climate data from the ClimateWizard database}
\usage{
getClimateWizardData(coordinates, scenario, start_year, end_year,
  baseline = c(1950, 2005), metric = "monthly_min_max_temps",
  GCMs = "all", temperature_generation_scenarios = FALSE)
}
\arguments{
\item{coordinates}{position of the point of interest, specified by a vector
with two elements that are called longitude and latitude (e.g. c(longitude=10,
latitude=20)).}

\item{scenario}{representative concentration pathway scenario. Can only be
"historical", "rcp45" or "rcp85".}

\item{start_year}{start year of the interval, for which data is to be summarized.}

\item{end_year}{end year of the interval, for which data is to be summarized.}

\item{baseline}{numeric vector of length 2 indicating the time interval to be used
as baseline for the climate scenario. The function then returns projected values relative
to this baseline. Defaults to c(1950,2005) for the standard
baseline of the ClimateWizard dataset, but can also assume different values. Needs
to be set to NA for the function to return absolute values.}

\item{metric}{vector of metrics to output, from a list specified in the reference
provided above. This can also be "monthly_min_max_temps", which returns all
mean monthly minimum and maximum temperatures.}

\item{GCMs}{vector of GCMs to be accessed, from a list specified in the above
reference. This can also be "all" for all available GCMs (as of January 2018).}

\item{temperature_generation_scenarios}{parameter to indicate whether the scenarios to be
generated should be formatted in such a way that they are direclty usable by
chillR's temperature_generation function. This is only applicable, when metric==
'monthly_min_max_temps'.}
}
\value{
data.frame containing the requested information.
}
\description{
This function makes use of an API provided by the International
Center for Tropical Agriculture (CIAT) to access climate scenario
data for a location of interest. Climate model runs are queried
and data returned and summarized according to the specified parameters.
A number of metrics are available for several climate models, which are listed in
https://redmine.cde.unibe.ch/attachments/download/673/DocumentationRESTAPIforWOCAT_v3.pdf.
Refer to this document for details on what can be downloaded. This function
provides the additional option of automatically retrieving all data referring to changes
in daily temperature extremes (by month), by setting the ```metric``` parameter to
"monthly_min_max_temps". It also offers the option to automatically obtain data for
all climate models included in the database (as of January 2018).
#'
}
\examples{

getClimateWizardData(coordinates=c(longitude=10.613975,latitude=34.933439),
  scenario="historical",
  start_year=1970,
  end_year=2000,
  metric=c("CD18","R02"),
  GCMs=c("bcc-csm1-1","BNU-ESM"))


}
\references{
Girvetz E, Ramirez-Villegas J, Navarro C, Rodriguez C, Tarapues J, undated.
ClimateWizard REST API for querying climate change data.
https://redmine.cde.unibe.ch/attachments/download/673/DocumentationRESTAPIforWOCAT_v3.pdf
}
\author{
Eike Luedeling
}
\keyword{utility}
