% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runn_mean.R
\name{runn_mean_pred}
\alias{runn_mean_pred}
\title{Prediction based on a running mean}
\usage{
runn_mean_pred(
  indep,
  dep,
  pred,
  runn_mean = 11,
  na.rm = FALSE,
  exclude_central_value = FALSE,
  FUN = mean
)
}
\arguments{
\item{indep}{numeric vector of independent variables, should be sequential}

\item{dep}{numeric vector of dependent variables}

\item{pred}{numeric vector of values to be predicted}

\item{runn_mean}{number of vector elements to use for calculating the
running mean}

\item{na.rm}{ignore NA values when calculating means. Defaults to FALSE.}

\item{exclude_central_value}{exclude central value in calculating means.
Defaults to FALSE.}

\item{FUN}{function to be applied. For a running mean, this is usually mean (the
default), but other functions can also be specified here (the na.rm parameter
won't work then, and the function has to be dependent on one numeric variable only.}
}
\value{
list of two elements, with $x containing the values to be predicted and $predicted
the predicted values
}
\description{
Function to predict values based on a running mean (or another function) of a numeric vector.
}
\details{
The running mean calculation that underlies the prediction is based purely on the sequence of
observed values, without accounting for any variation in intervals of the independent data. This
means that the function performs best with regularly spaced independent variables. Note that the
function will return NA when asked to predict values that are outside the range of independent values
provided as input. The prediction results are computed by linearly interpolating between the running
mean values determined for the nearest neighbors of the value that is to be predicted.
}
\examples{

indep<-(1:100)
dep<-sin(indep/20)+rnorm(100)/5
pred<-c(12,13,51,70,90)

predicted<-runn_mean_pred(indep,dep,pred,runn_mean = 25)

plot(dep~indep)
points(predicted$predicted~predicted$x,col="red",pch=15)

}
\author{
Eike Luedeling
}
\keyword{"running}
\keyword{mean"}
\keyword{prediction}
