% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m2doc.R
\name{m2doc}
\alias{m2doc}
\title{Rewrite Terms and Frequencies into Many Files}
\usage{
m2doc(m, checks = FALSE)
}
\arguments{
\item{m}{a numeric matrix, data frame is not allowed. It must represent a document term 
matrix, rather than a term document matrix. Each row of the matrix represents a text. The 
matrix should have column names as terms to be written, but if it is \code{NULL}, the 
function will take them as "term1", "term2", "term3", ...No \code{NA} in the matrix 
is allowed.}

\item{checks}{should be \code{TRUE} or \code{FALSE}. If it is TRUE, the function will 
check whether there is any \code{NA} in the input, whether it is numeric,  and whether 
there is any negative number. Default is \code{FALSE} to save time.}
}
\value{
a character vector, each element is a text with repeated 
terms (by \code{\link{rep}}) linked by a space.
}
\description{
Given a matrix representing a document term matrix, this function takes each row as term 
frequencies for one file, and rewrite each row as a text.
Some algorithms require object created by \code{\link[tm]{DocumentTermMatrix}}, 
If you already convert it into a matrix, you can use this function to convert it into corpus 
and create document term matrix again.
}
\examples{
s <- sample(1:5, 20, replace = TRUE)
m <- matrix(s, nrow = 5)
colnames(m) <- c("r", "text", "mining", "data")
m2doc(m)
}

