% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-factor.R
\name{chk_factor}
\alias{chk_factor}
\alias{vld_factor}
\title{Check Factor}
\usage{
chk_factor(x, x_name = NULL)

vld_factor(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if factor using

\code{is.factor(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_factor}: Validate Factor
}}

\examples{
# chk_factor
chk_factor(factor("1"))
try(chk_factor("1"))
# vld_factor
vld_factor(factor("1"))
vld_factor(factor(0))
vld_factor("1")
vld_factor(1L)
}
\seealso{
Other chk_typeof: 
\code{\link{chk_character_or_factor}()},
\code{\link{chk_character}()},
\code{\link{chk_double}()},
\code{\link{chk_environment}()},
\code{\link{chk_integer}()},
\code{\link{chk_list}()},
\code{\link{chk_logical}()}
}
\concept{chk_typeof}
