% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_hmc_info.R
\name{extract_hmc_info}
\alias{extract_hmc_info}
\title{Extract HMC Sampler Information}
\usage{
extract_hmc_info(object)
}
\arguments{
\item{object}{An object of class \code{CmdStanMCMC}}
}
\value{
A list including

\itemize{

\item \code{inv_metric}: Inverse metric for each chain
(with \code{matrix = FALSE}).

\item \code{step_size_adapt}: Step size adaptation for each chain.

}
}
\description{
Extract the inverse metric and step size adaption from
\code{CmdStanMCMC} objects.
}
\note{
This is primarily used internally.
}
\examples{

\dontrun{

library(cmdstanr)

fit_schools_ncp_mcmc <- cmdstanr_example("schools_ncp")

extract_hmc_info(fit_schools_ncp_mcmc)

}
}
