% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walking.R
\name{neighborhoodWalking}
\alias{neighborhoodWalking}
\title{Compute walking path neighborhoods.}
\usage{
neighborhoodWalking(pump.select = NULL, vestry = FALSE,
  statistic = "address", weighted = TRUE, snow = FALSE,
  multi.core = FALSE)
}
\arguments{
\item{pump.select}{Numeric. Default is NULL: all pumps are used. Otherwise, selection by a vector of numeric IDs: 1 to 13 for \code{pumps}; 1 to 14 for \code{pumps.vestry}.}

\item{vestry}{Logical. TRUE uses the 14 pumps from the Vestry Report. FALSE uses the 13 in the original map.}

\item{statistic}{Character. "address" computes the number of addresses in each selected pump neighborhood. "fatality" computes the number of fatalities in pump neighborhoods.}

\item{weighted}{Logical. TRUE uses distance weighted by edge length (i.e., road length). FALSE uses unweighted distance.}

\item{snow}{Logical. TRUE computes Snow's Broad Street pump neighborhood. Note: this sets "pump.select" to 7 and "vestry" to NULL.}

\item{multi.core}{Logical or Numeric. TRUE uses parallel::detectCores(). FALSE uses one, single core. With Numeric, you specify the number logical cores (rounds with as.integer()). On Windows, only "multi.core = FALSE" is available.}
}
\value{
An R list with 12 objects:
\itemize{
  \item{\code{distances}: walking distances to selected pumps.}
  \item{\code{pump}: vector of selected pumps.}
  \item{\code{nearest.pump}: an observed fatality's nearest pump.}
  \item{\code{pump.seg}: "trimmed" neighborhood road segments based on observed fatalities.}
  \item{\code{pump.case}: observed fatality IDs by pump neighborhood.}
  \item{\code{sim.pump.seg}:  "trimmed" neighborhood road segments based on simulated fatalities.}
  \item{\code{sim.pump.case}: simulated fatality ID by pump neighborhood.}
  \item{\code{observed}: observed neighborhood fatality counts.}
  \item{\code{expected}: expected neighborhood fatality counts, based on road length.}
  \item{\code{pump.select}: "pump.select" from neighborhoodWalking().}
  \item{\code{statistic}: "statistic" from neighborhoodWalking().}
  \item{\code{vestry}: "vestry" from neighborhoodWalking().}
}
}
\description{
Data for walking neighborhoods for John Snow's 1854 London cholera data.
}
\section{Notes}{
 This function is computationally intensive (the default configuration takes about 1-2 minutes to run on a single core). However, seven configurations will return pre-computed results. The first three use the 13 pumps in the original map: 1) the default set of arguments, which uses all pumps; 2) the default set excluding the pump on Little Marlborough Street (pump 6), and 3) the default set with just the Little Marlborough Street and the Broad Street pumps (6 and 7). The next three use the same set of arguments as above but uses the 14 pumps in the second version from the Vestry report. This includes a repositioned Broad Street pump. The seventh and final is Snow's Broad Street pump neighborhood, which represents his graphical annotation of the version of the map that appeared in the Vestry report.
}

\examples{
neighborhoodWalking()
neighborhoodWalking(pump.select = -6)
}
\seealso{
\code{\link{plot.walking}}, \code{\link{summary.walking}}, \code{vignette("pump.neighborhoods")}
}
