% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cholera.R
\docType{package}
\name{cholera-package}
\alias{cholera-package}
\title{cholera: amend, augment and aid analysis of John Snow's cholera map}
\description{
Amend, augment and aid the analysis of John Snow's cholera map.
}
\details{
Features:

\itemize{
\item Fixes three apparent coding errors in Dodson and Tobler's 1992 digitization of Snow's map.
\item "Unstacks" the data in two ways to make analysis and visualization easier and more meaningful.
\item Computes and visualizes "pump neighborhoods" based on Voronoi tessellation, Euclidean distance, and walking distance.
\item Ability to overlay graphical elements and features like kernel density, Voronoi diagrams, Snow's Broad Street neighborhood, and notable landmarks (John Snow's residence, the Lion Brewery, etc.) via add*() functions.
\item Includes a variety of functions to highlight specific cases, roads, pumps and paths.
\item Appends actual street names to roads data.
\item Includes the revised pump data used in the second version of Snow's map from the Vestry report, which includes the "correct" location of the Broad Street pump.
\item Adds two different aggregate time series fatalities data sets, taken from the Vestry report.
\item Computes and visualizes two types of "pump neighborhoods": Voronoi, based on Euclidean distance, and walking, based on computed walking distances.
}

To learn more, see the vignettes:

\code{vignette("duplicate.missing.cases")}

\code{vignette("unstacking.bars")}

\code{vignette("pump.neighborhoods")}

\code{vignette("kernel.density")}

\code{vignette("roads")}

\code{vignette("time.series")}

And, if interested, see the relevant lab notes, which are available online: \href{https://github.com/lindbrook/cholera/blob/master/docs/pump.neighborhoods.notes.md}{Pump Neighborhood},  \href{https://github.com/lindbrook/cholera/blob/master/docs/duplicate.missing.cases.notes.md}{Duplicate and Missing Cases} and  \href{https://github.com/lindbrook/cholera/blob/master/docs/unstacking.bars.notes.md}{"Unstacking" Bars}
}
