% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/euclideanPath.R
\name{plot.euclidean_path}
\alias{plot.euclidean_path}
\title{Plot the path of the Euclidean distance between cases and/or pumps.}
\usage{
\method{plot}{euclidean_path}(x, zoom = TRUE, radius = 0.5,
  unit.posts = "distance", unit.interval = NULL, ...)
}
\arguments{
\item{x}{An object of class "euclidean_path" created by euclideanPath().}

\item{zoom}{Logical.}

\item{radius}{Numeric. Controls the degree of zoom.}

\item{unit.posts}{Character. "distance" for mileposts; "time" for timeposts; NULL for no posts.}

\item{unit.interval}{Numeric. Set interval between posts. When "unit.posts" is "distance", "unit.interval" automatically defaults to 50 meters. When "unit.posts" is "time", "unit.interval" automatically defaults to 60 seconds.}

\item{...}{Additional plotting parameters.}
}
\value{
A base R plot.
}
\description{
Plot the path of the Euclidean distance between cases and/or pumps.
}
\examples{
plot(euclideanPath(15))
plot(euclideanPath(15), unit.posts = "time")
}
