% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addNeighborhoodWalking.R
\name{addNeighborhoodWalking}
\alias{addNeighborhoodWalking}
\title{Add expected walking neighborhoods.}
\usage{
addNeighborhoodWalking(pump.subset = NULL, pump.select = NULL,
  vestry = FALSE, weighted = TRUE, polygon.method = "pearl.string",
  path = NULL, path.color = NULL, path.width = 3,
  alpha.level = 0.25, polygon.type = "solid", polygon.col = NULL,
  polygon.lwd = 2, multi.core = FALSE)
}
\arguments{
\item{pump.subset}{Numeric. Vector of numeric pump IDs to subset from the neighborhoods defined by \code{pump.select}. Negative selection possible. \code{NULL} uses all pumps in \code{pump.select}.}

\item{pump.select}{Numeric. Numeric vector of pump IDs that define which pump neighborhoods to consider (i.e., specify the "population"). Negative selection possible. \code{NULL} selects all pumps.}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry Report. \code{FALSE} uses the 13 in the original map.}

\item{weighted}{Logical. \code{TRUE} computes shortest path weighted by road length. \code{FALSE} computes shortest path in terms of the number of nodes.}

\item{polygon.method}{Character. Method of computing polygon vertices: "pearl.string" or "traveling.salesman".}

\item{path}{Character. "expected" or "observed".}

\item{path.color}{Character. Use a single color for all paths. \code{NULL} uses neighborhood colors defined by \code{snowColors()}.}

\item{path.width}{Numeric. Set width of paths.}

\item{alpha.level}{Numeric. Alpha level transparency for area plot: a value in [0, 1].}

\item{polygon.type}{Character. "perimeter" or "solid".}

\item{polygon.col}{Character.}

\item{polygon.lwd}{Numeric.}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores. On Windows, only \code{multi.core = FALSE} is available.}
}
\description{
Add expected walking neighborhoods.
}
\note{
This function is computationally intensive. On a single core of a 2.3 GHz Intel i7, plotting observed paths to PDF takes about 5 seconds while doing so for expected paths takes about 30 seconds. Using the parallel implementation on 4 physical (8 logical) cores, these times fall to about 4 and 13 seconds. Note that parallelization is currently only available on Linux and Mac, and that although some precautions are taken in R.app on macOS, the developers of the 'parallel' package, which \code{neighborhoodWalking()} uses, strongly discourage against using parallelization within a GUI or embedded environment. See \code{vignette("parallel")} for details.
}
\examples{
\dontrun{

streetNameLocator("marshall street", zoom = 0.5)
addNeighborhoodWalking()
}
}
