#' cholera: amend, augment and aid analysis of John Snow's cholera map
#'
#' Amend, augment and aid the analysis of John Snow's cholera map.
#'
#' Features:
#'
#' \itemize{
#' \item Fixes three apparent coding errors in Dodson and Tobler's 1992 digitization of Snow's map.
#' \item "Unstacks" the data in two ways to make analysis and visualization easier and more meaningful.
#' \item Computes and visualizes "pump neighborhoods" based on Voronoi tessellation, Euclidean distance, and walking distance.
#' \item Ability to overlay graphical elements and features like kernel density, Voronoi diagrams, Snow's Broad Street neighborhood, and notable landmarks (John Snow's residence, the Lion Brewery, etc.) via add*() functions.
#' \item Includes a variety of functions to highlight specific cases, roads, pumps and paths.
#' \item Appends actual street names to roads data.
#' \item Includes the revised pump data used in the second version of Snow's map from the Vestry report, which includes the "correct" location of the Broad Street pump.
#' \item Adds two different aggregate time series fatalities data sets, taken from the Vestry report.
#' \item Support for parallel computation on Linux, macOS and Windows.
#' \item PWith 'cholera' version >= 0.8.0, preliminary and provisional support for georeferenced (longitude and latitude) versions of data and functions.
#' }
#'
#' To learn more, see the vignettes:
#'
#' \code{vignette("duplicate.missing.cases")}
#'
#' \code{vignette("kernel.density")}
#'
#' \code{vignette("parallelization")}
#'
#' \code{vignette("pump.neighborhoods")}
#'
#' \code{vignette("roads")}
#'
#' \code{vignette("tiles.polygons")}
#'
#' \code{vignette("time.series")}
#'
#' \code{vignette("unstacking.bars")}
#'
#' @docType package
#' @name cholera-package
NULL
