% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admin1_region.R
\name{admin1_region_choropleth}
\alias{admin1_region_choropleth}
\title{Create a map of Administrative Level 1 regions}
\usage{
admin1_region_choropleth(df, title = "", legend = "", num_colors = 7,
  zoom = NULL, reference_map = FALSE)
}
\arguments{
\item{df}{A data.frame with a column named "region" and a column named "value".  Elements in 
the "region" column must exactly match how regions are named in the "region" column in ?admin1.regions
in the choroplethrAdmin1 package}

\item{title}{An optional title for the map.}

\item{legend}{An optional name for the legend.}

\item{num_colors}{The number of colors on the map. A value of 1 
will use a continuous scale. A value in [2, 9] will use that many colors.}

\item{zoom}{An optional vector of regions to zoom in on. Elements of this vector must exactly 
match the names of regions as they appear in the "region" column of ?admin1.regions.}

\item{reference_map}{If true, render the choropleth over a reference map from Google Maps.}
}
\description{
Unlike ?admin1_choropleth, the regions here can span multiple countries.
}
\details{
The map used comes from ?admin1.map in the choroplethrAdmin1 package. See ?get_admin_countries
and ?get_admin_regions in the choroplethrAdmin1 package for help with the spelling of regions.
}
\examples{
\dontrun{

library(choroplethrAdmin1)

# map of continental us + southern canada
 
data("continental_us_states")
lower_canada = c("british columbia", "alberta", "saskatchewan", "manitoba", "ontario", "quebec")
regions = c(lower_canada, continental_us_states)
df = data.frame(region=regions, value=sample(1:length(regions)))

admin1_region_choropleth(df) 

}
}

