% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.R
\name{sp_converter}
\alias{sp_converter}
\title{Converter for Agilent MassHunter UV files}
\usage{
sp_converter(
  file,
  format_out = c("matrix", "data.frame"),
  read_metadata = TRUE
)
}
\arguments{
\item{file}{path to file}

\item{format_out}{R format. Either \code{matrix} or \code{data.frame}.}

\item{read_metadata}{Logical. Whether to read metadata and attach it to the
chromatogram.}
}
\value{
A chromatogram in \code{data.frame} format (retention time x wavelength).
}
\description{
Converts a single chromatogram from MassHunter \code{.sp} format to R \code{data.frame}.
}
\details{
Uses the \href{https://github.com/bovee/aston}{Aston} file parser.
}
