% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chromoMapToHTML.R
\name{chromoMapToHTML}
\alias{chromoMapToHTML}
\title{convert chromoMap plots into customizable HTML documents}
\usage{
chromoMapToHTML(chromoMap, file = "chromoMap.html",
  title = "Choose attractive Title for your chromoMap", dir = "",
  description = "", openAfterSave = FALSE)
}
\arguments{
\item{chromoMap}{an object of the chromoMap plot}

\item{file}{name of the file to save with, default is chromoMap.html}

\item{title}{A string for the Title that can be included in the document}

\item{dir}{specify the directory of the file.default is current directory.}

\item{description}{A string for adding description of the plot}

\item{openAfterSave}{A boolean to specify whether to open the document after save}
}
\description{
Helpful in sharing the graphics. Also give options to add text
}
\examples{

library(chromoMap)
data("pancandata")
chmap = chromoMap(pancandata$data2,type="heatmap-double")

#saving plot to HTML document
#for desription
my_desc = "you can write a paragraph to describe your plot"
chromoMapToHTML(chmap,title = "Expression profile Comparison in normal vs tumor",
description = my_desc,openAfterSave = TRUE,dir=tempdir())




}
