% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_xifti_surface.R
\name{view_xifti_surface}
\alias{view_xifti_surface}
\alias{view_cifti_surface}
\alias{viewCIfTI_surface}
\alias{viewcii_surface}
\title{View cortical surface data in a \code{"xifti"}}
\usage{
view_xifti_surface(
  xifti = NULL,
  surfL = NULL,
  surfR = NULL,
  color_mode = "auto",
  zlim = NULL,
  colors = NULL,
  idx = NULL,
  hemisphere = NULL,
  together = NULL,
  together_ncol = NULL,
  together_title = NULL,
  view = c("both", "lateral", "medial"),
  widget = NULL,
  title = NULL,
  slider_title = "Index",
  fname = FALSE,
  fname_suffix = c("names", "idx"),
  legend_fname = "[fname]_legend",
  legend_ncol = NULL,
  legend_alllevels = FALSE,
  legend_embed = NULL,
  digits = NULL,
  scientific = NA,
  cex.title = NULL,
  text_color = "black",
  bg = NULL,
  NA_color = "white",
  borders = FALSE,
  alpha = 1,
  edge_color = NULL,
  vertex_color = NULL,
  vertex_size = 0,
  material = NULL,
  shadows = 1,
  width = NULL,
  height = NULL,
  zoom = NULL
)

view_cifti_surface(
  xifti = NULL,
  surfL = NULL,
  surfR = NULL,
  color_mode = "auto",
  zlim = NULL,
  colors = NULL,
  idx = NULL,
  hemisphere = NULL,
  together = NULL,
  together_ncol = NULL,
  together_title = NULL,
  view = c("both", "lateral", "medial"),
  widget = NULL,
  title = NULL,
  slider_title = "Index",
  fname = FALSE,
  fname_suffix = c("names", "idx"),
  legend_fname = "[fname]_legend",
  legend_ncol = NULL,
  legend_alllevels = FALSE,
  legend_embed = NULL,
  digits = NULL,
  scientific = NA,
  cex.title = NULL,
  text_color = "black",
  bg = NULL,
  NA_color = "white",
  borders = FALSE,
  alpha = 1,
  edge_color = NULL,
  vertex_color = NULL,
  vertex_size = 0,
  material = NULL,
  shadows = 1,
  width = NULL,
  height = NULL,
  zoom = NULL
)

viewCIfTI_surface(
  xifti = NULL,
  surfL = NULL,
  surfR = NULL,
  color_mode = "auto",
  zlim = NULL,
  colors = NULL,
  idx = NULL,
  hemisphere = NULL,
  together = NULL,
  together_ncol = NULL,
  together_title = NULL,
  view = c("both", "lateral", "medial"),
  widget = NULL,
  title = NULL,
  slider_title = "Index",
  fname = FALSE,
  fname_suffix = c("names", "idx"),
  legend_fname = "[fname]_legend",
  legend_ncol = NULL,
  legend_alllevels = FALSE,
  legend_embed = NULL,
  digits = NULL,
  scientific = NA,
  cex.title = NULL,
  text_color = "black",
  bg = NULL,
  NA_color = "white",
  borders = FALSE,
  alpha = 1,
  edge_color = NULL,
  vertex_color = NULL,
  vertex_size = 0,
  material = NULL,
  shadows = 1,
  width = NULL,
  height = NULL,
  zoom = NULL
)

viewcii_surface(
  xifti = NULL,
  surfL = NULL,
  surfR = NULL,
  color_mode = "auto",
  zlim = NULL,
  colors = NULL,
  idx = NULL,
  hemisphere = NULL,
  together = NULL,
  together_ncol = NULL,
  together_title = NULL,
  view = c("both", "lateral", "medial"),
  widget = NULL,
  title = NULL,
  slider_title = "Index",
  fname = FALSE,
  fname_suffix = c("names", "idx"),
  legend_fname = "[fname]_legend",
  legend_ncol = NULL,
  legend_alllevels = FALSE,
  legend_embed = NULL,
  digits = NULL,
  scientific = NA,
  cex.title = NULL,
  text_color = "black",
  bg = NULL,
  NA_color = "white",
  borders = FALSE,
  alpha = 1,
  edge_color = NULL,
  vertex_color = NULL,
  vertex_size = 0,
  material = NULL,
  shadows = 1,
  width = NULL,
  height = NULL,
  zoom = NULL
)
}
\arguments{
\item{xifti}{A \code{"xifti"} object.}

\item{surfL, surfR}{(Optional) The brain surface model to use. Each can be a
\code{"surf"} object, any valid argument to \code{\link{read_surf}} , or one
of \code{"very inflated"}, \code{"inflated"}, or \code{"midthickness"}. If
provided, it will override \code{xifti$surf$cortex_left} or
\code{xifti$surf$cortex_right} if it exists. Leave as \code{NULL} (default)
to use \code{xifti$surf$cortex_left} or \code{xifti$surf$cortex_right} if it
exists, or the default inflated surfaces if it does not exist.}

\item{color_mode}{(Optional) \code{"sequential"}, \code{"qualitative"},
\code{"diverging"}, or \code{"auto"} (default). Auto mode will use the
qualitative color mode if the \code{"xifti"} object represents a .dlabel
CIFTI (intent 3007). Otherwise, it will use the diverging mode if the data
contains both positive and negative values, and the sequential mode if the
data contains >90\\% positive or >90\\% negative values. See
\code{\link{make_color_pal}} for more details.}

\item{zlim}{(Optional) Controls the mapping of values to each
color in \code{colors}. If the length is longer than
one, using -Inf will set the value to the data minimum, and Inf will set
the value to the data maximum. See \code{\link{make_color_pal}}
description for more details.}

\item{colors}{(Optional) \code{"ROY_BIG_BL"}, vector of colors to use,
the name of a ColorBrewer palette (see \code{RColorBrewer::brewer.pal.info}
and colorbrewer2.org), the name of a viridisLite palette, or a data.frame
with columns \code{"color"} and \code{"value"} (will override \code{zlim}).
If \code{NULL}
(default), will use the positive half of \code{"ROY_BIG_BL"} (sequential),
\code{"Set2"} (qualitative), or the full \code{"ROY_BIG_BL"} (diverging). An
exception to these defaults is if the \code{"xifti"} object represents a
.dlabel CIFTI (intent 3007), in which case the colors in the label table
will be used. See \code{\link{make_color_pal}} for more details.}

\item{idx}{The time/column index of the data to display. \code{NULL} (default)
will display the first column.

If its length is greater than one, and \code{isFALSE(fname)},
a widget must be used since a single OpenGL window cannot show multiple
indexes. A slider will be added to the widget to control what time/column
is being displayed.}

\item{hemisphere}{Which brain cortex to display: "both" (default), "left",
or "right". Each will be plotted in a separate panel column.

If a brain cortex is requested but no surface is available, a default
inflated surface will be used.

This argument can also be \code{NULL} (default). In this case, the default
inflated surface included with \code{ciftiTools} will be used for each
cortex with data (i.e. if \code{xifti$data$cortex_left} and/or
\code{xifti$data$cortex_right} exist).

Surfaces without data will be colored white.}

\item{together}{Only applies if saving image files (\code{!isFALSE(fname)}).
Use this argument to create and save a composite image which combines
multiple plots. \code{NULL} (default) will not combine any plots. Otherwise,
this argument should be a character vector with one or more of the
following entries:

\code{"leg"} to combine the color legend with each \code{"xifti"} data plot.
Overrides/ignores \code{legend_embed}.

\code{"idx"} to place all the plots for the different \code{"idx"} in a grid.
If the data is not qualitative, a shared color bar will be added to the bottom
of the composite. If the data is qualitative, a shared color legend will be
added to the bottom only if \code{"leg"} is in \code{together}.
For greater control see \code{view_comp} or \code{grid::arrangeGrob}.}

\item{together_ncol}{If \code{"idx" \%in\% together}, this determines the number
of columns to use in the array of subplots for different indices.
By default, the number of columns and rows will be determined such that they
are about equal.}

\item{together_title}{If a composite image is made based on \code{together},
use this argument to add a grand title to the composite image. Should be
a length-one character vector or \code{NULL} (default) to not add a grand title.}

\item{view}{Which view to display: \code{"lateral"}, \code{"medial"}, or
\code{"both"}. If \code{NULL} (default), both views will be shown. Each view
will be plotted in a separate panel row.}

\item{widget}{Display the plot in an htmlwidget? Should be logical or
\code{NULL} (default), in which case a widget will be used only if needed
(\code{length(idx)>1 & isFALSE(fname)}, \code{fname} is a file path to an
.html file, or if \code{rgl.useNULL()}).}

\item{title}{Optional title(s) for the plot(s). It will be printed at the top
in a separate subplot with 1/4 the height of the brain cortex subplots.

Default: \code{NULL} will not use any title if \code{length(idx)==1}.
Otherwise, it will use the time index (".dtseries") or name
(.dscalar or .dlabel) of each data column.

To use a custom title(s), use a length 1 character vector (same title for
each plot) or length \code{length(idx)} character vector (different title
for each plot). Set to \code{NULL} or an empty character to omit the title.

If the title is non-empty but does not appear, try lowering \code{cex.title}.}

\item{slider_title}{Text at bottom of plot that will be added if a slider
is used, to provide a title for it. Default: \code{"Index"}.
If \code{NULL} or an empty character, no title will be added.}

\item{fname}{Save the plot(s) (and color legend if applicable)?

If \code{isFALSE(fname)} (default), no files will be written.

If \code{fname} is a length-1 character vector ending in ".html", an html
with an interactive widget will be written.

If neither of the cases above apply, a png image will be written for each
\code{idx}. If \code{isTRUE(fname)} the files will be named by the
data column names (underscores will replace spaces). Or, set \code{fname} to a
length 1 character vector to name files by this suffix followed by the
\code{fname_suffix}. Or, set \code{fname} to a character vector with the same
length as \code{idx} to name the files exactly.}

\item{fname_suffix}{Either the data column names (\code{"names"}) or the
index value (\code{"idx"}).}

\item{legend_fname}{Save the color legend? Since the legend is the same
for each \code{idx} only one legend is written even if \code{length(idx)>1}.
This argument can be \code{NULL} to not save the legend, an exact file
path, or a length-one character vector with "[fname]" in it, which will
name the legend based on \code{fname\[1\]}. For example, if \code{fname\[1\]}
is \code{"plots/my_cifti.png"} and \code{legend_fname} is \code{"\[fname\]_legend"}
(default), then the legend plot will be saved to \code{"plots/my_cifti_legend.png"}.}

\item{legend_ncol}{Number of columns in color legend. If
\code{NULL} (default), use 10 entries per row. Only applies if the color
legend is used (qualitative data).}

\item{legend_alllevels}{Show all label levels in the color legend? If
\code{FALSE} (default), just show the levels present in the data being
viewed. Only applies if the color legend is used (qualitative data).}

\item{legend_embed}{Should the colorbar be embedded in the plot?
It will be positioned in the bottom-left corner, in a separate subplot
with 1/4 the height of the brain cortex subplots. Default: \code{TRUE}.
If \code{FALSE}, print/save it separately instead.

Only applies if the color bar is used (sequential or diverging data)
or if \code{"leg" \%in\% together}. Otherwise the color legend
(qualitative data) cannot be embedded at the moment.}

\item{digits}{The number of digits for the colorbar legend ticks.
If \code{NULL} (default), let \code{\link{format}} decide.}

\item{scientific}{Use scientific notation? If \code{NA} (default), let
\code{\link{format}} decide.}

\item{cex.title}{Font size multiplier for the title. \code{NULL} (default)
will use \code{2} for titles less than 20 characters long, and smaller
sizes for increasingly longer titles.}

\item{text_color}{Color for text in title and colorbar legend. Default:
\code{"black"}.}

\item{bg}{Background color. \code{NULL} will use \code{"white"}. Does not affect
the color legend or color bar if printed separately: those will always have
white backgrounds.}

\item{NA_color}{The color for the medial wall and \code{NA} values. Default:
\code{"white"}. Also used to color the entire surface for \code{view_surf}.}

\item{borders}{Only applicable if \code{color_mode} is \code{"qualitative"}.
Border vertices will be identified (those that share a face with at least
one vertex of a different value) and colored over. If this argument is
\code{TRUE} borders will be colored in black; provide the name of a different
color to use that instead. If \code{FALSE} or \code{NULL} (default), do
not draw borders.}

\item{alpha}{Transparency value for mesh coloring, between 0 and 1. Default:
\code{1.0} (no transparency).}

\item{edge_color}{Outline each edge in this color. Default: \code{NULL} (do
not outline the edges).}

\item{vertex_color}{Draw each vertex in this color. Default:
\code{"black"}. Vertices are only drawn if \code{vertex_size > 0}}

\item{vertex_size}{Draw each vertex with this size. Default: \code{0}
(do not draw the vertices).}

\item{material}{A list of materials from \code{\link[rgl]{material3d}}
to use. For example, \code{list(lit=FALSE, smooth=FALSE)} will use exact colors
from the color scale, rather than adding geometric shading and interpolating
vertex colors. If \code{NULL}, use defaults.}

\item{shadows}{Number from 0 (maximum added lighting) to 1 (no added
lighting) to control the darkness and extent of shadowing on the 3D surface.
Default: \code{1}. Shadows help render the shape of the surface, but can
be distracting if interpretation of the data depends on small differences in
brightness along the color scale.}

\item{width, height}{The dimensions of the RGL window, in pixels. If both are
\code{NULL} (default), these dimensions depend on type of output (Open GL
window or widget) and subplots (\code{hemisphere}, \code{view}, \code{title},
and \code{slider_title}) and are chosen to be the largest plot within a
1500 x 700 area (Open GL window) or 600 x 700 area (widget) that maintains
a brain hemisphere subplot dimensions ratio of 10 x 7. Specifying only one
will set the other to maintain this aspect ratio. Both can be specified to
set the dimensions exactly, but note that the dimensions cannot be larger
than the screen resolution. (These arguments do not affect the size of the
legend, which cannot be controlled.)

The plot will be taller than \code{height} to accommodate a title or color
bar.

If multiple \code{idx} are being composited with \code{together}, these
arguments refer to a single \code{idx} within the composited plot, and not
the composited plot itself.}

\item{zoom}{Adjust the sizes of the brain meshes. Default: \code{NULL} (will
be set to 0.6 or 160\\% for the Open GL window, and 0.67 or 167\\% for the
widget.)}
}
\value{
If a png or html file(s) were written, the names of the files for
each index (and color legend if applicable) will be returned. Otherwise,
the widget itself is returned if a widget was used, and the rgl object IDs
are returned if an Open GL window was used. The rgl object IDs are useful
for further programmatic manipulation of the Open GL window.
}
\description{
Visualize \code{"xifti"} cortical data using an interactive Open GL window
or htmlwidget made with \code{rgl}. The \code{rmarkdown} package is
required for the htmlwidget functionality.
}
\section{Navigating and Embedding the Interactive Plots}{


To navigate the interactive Open GL window and html widget, left click and
drag the cursor to rotate the meshes. Use the scroll wheel or right click
and drag to zoom. Press the scroll wheel and drag to change the field-of-view.
For Open GL windows, execute
\code{\link[rgl]{snapshot}} to save the current window as a .png file,
\code{\link[rgl:open3d]{close3d}} to close the window, and
\code{\link[rgl:viewpoint]{view3d}} to programmatically control the
perspective.

To embed an interactive plot in an R Markdown document, first execute
\code{rgl::setupKnitr()} to prepare the document for embedding the widget.
Then execute the plot command as you normally would to create a widget (i.e.
without specifying \code{fname}, and by requesting more than one \code{idx}
or by setting \code{widget} to \code{TRUE}). When the R Markdown document is
knitted, the interactive widget should be displayed below the chunk in which
the plot command was executed. See the vignette for an example.
}

\section{Embedding the Static Plots}{


To embed a static plot in an R Markdown document, first execute
\code{rgl::setupKnitr()} to prepare the document for embedding the snapshot
of the Open GL window. Then execute the plot command as you normally would
to create an Open GL window (i.e. without specifying \code{fname}, and by
requesting only one \code{idx}). In the options for the chunk in which the
plot command is executed, set \code{rgl=TRUE, format="png"}. You can also
control the image dimensions here e.g. \code{fig.height=3.8, fig.width=5}.
When the R Markdown document is knitted, the static plots should be
displayed below the chunk in which the plot command was executed. See the
vignette for an example.
}

\seealso{
Other visualizing: 
\code{\link{view_comp}()},
\code{\link{view_surf}()},
\code{\link{view_xifti}()},
\code{\link{view_xifti_volume}()}
}
\concept{visualizing}
