# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

atanLF <- function(x, r) {
    .Call(`_circglmbayes_atanLF`, x, r)
}

invAtanLF <- function(x, r) {
    .Call(`_circglmbayes_invAtanLF`, x, r)
}

#' Generate a random variate from the von Mises distribution
#'
#' This function generates a set of data from the von Mises distribution.
#' If kappa is very small, return a circular uniform draw, as otherwise the
#' algorithm will fail.
#'
#' @param n The number of random variates required.
#' @param mu The required mean direction, mu.
#' @param kp The required concentration, kappa.
#'
#' @return A vector of length n containing VM random variates.
#'
#' @export
rvmc <- function(n, mu, kp) {
    .Call(`_circglmbayes_rvmc`, n, mu, kp)
}

#' Sample a value from the Bessel exponential distribution
#'
#' This is an implementation of the algorithm of Forbes and Mardia (2015) to
#' sample from the Bessel exponential distribution, which is the conditional
#' distribution of the concentration parameter of a von Mises distribution
#' given the mean \code{mu}. The distribution is proportional to \eqn{exp(-
#' \eta g \kappa)/I_0(\kappa)^\eta}. Note that \code{beta_0} in Forbes and
#' Mardia (2015) is renamed \code{g} here.
#'
#' @param etag Numeric; This is \code{eta * g}, which should
#'   \code{-R*cos(mu-theta_bar)}, where \code{R} is the posterior mean
#'   resultant length, and \code{theta_bar} is the posterior mean, while
#'   \code{mu} is the current value of the mean.
#' @param eta Integer; This is the posterior sample size, which is n + c where
#'   c is the number of observations contained in the conjugate prior. For
#'   uninformative, \code{c = 0} and \code{eta = n}.
#'
#' @return A sampled value \code{kappa} from the Bessel exponential
#'   distribution.
#'
#' @export
sampleKappa <- function(etag, eta) {
    .Call(`_circglmbayes_sampleKappa`, etag, eta)
}

computeMeanDirection <- function(th) {
    .Call(`_circglmbayes_computeMeanDirection`, th)
}

computeResultantLength <- function(th) {
    .Call(`_circglmbayes_computeResultantLength`, th)
}

circQuantile <- function(th, q) {
    .Call(`_circglmbayes_circQuantile`, th, q)
}

estimateModeCirc <- function(x, cip) {
    .Call(`_circglmbayes_estimateModeCirc`, x, cip)
}

computeHDICirc <- function(x, cip) {
    .Call(`_circglmbayes_computeHDICirc`, x, cip)
}

estimateMode <- function(x, cip) {
    .Call(`_circglmbayes_estimateMode`, x, cip)
}

computeHDI <- function(x, cip) {
    .Call(`_circglmbayes_computeHDI`, x, cip)
}

logProbNormal <- function(x, mu, sd) {
    .Call(`_circglmbayes_logProbNormal`, x, mu, sd)
}

truncCauchyPdf <- function(x, m, w) {
    .Call(`_circglmbayes_truncCauchyPdf`, x, m, w)
}

circGLMC <- function(th, X, D, conj_prior, bt_prior, starting_values, burnin, thin, bwb, kappaModeEstBandwith, CIsize, Q, r, returnPostSample, bt_prior_type, reparametrize, groupMeanComparisons) {
    .Call(`_circglmbayes_circGLMC`, th, X, D, conj_prior, bt_prior, starting_values, burnin, thin, bwb, kappaModeEstBandwith, CIsize, Q, r, returnPostSample, bt_prior_type, reparametrize, groupMeanComparisons)
}

