% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateCircGLMData.R
\name{generateCircGLMData}
\alias{generateCircGLMData}
\title{Generate data that follows the circular GLM model}
\usage{
generateCircGLMData(
  n = 30,
  residkappa = 5,
  nconpred = 2,
  ncatpred = 2,
  truebeta0 = pi/2,
  truebeta = rep(0.25, nconpred),
  truedelta = rep(1, ncatpred),
  linkfun = function(x) 2 * atan(x)
)
}
\arguments{
\item{n}{Integer; the sample size to be generated.}

\item{residkappa}{A non-negative numeric; the residual concentration
parameter. This is the \eqn{\kappa} of the von Mises distribution that the
residuals follow.}

\item{nconpred}{Integer; The number of continuous (linear) predictors to be
generated.}

\item{ncatpred}{Integer; The number of categorical predictors to be
generated.}

\item{truebeta0}{An angle in radians representing \code{beta_0}, which
functions as the intercept.}

\item{truebeta}{A numeric vector containing the values for the regression
coefficients of the continuous predictors.}

\item{truedelta}{A numeric vector containing angles in radians that represent
the group differences for each of the categorical predictors.}

\item{linkfun}{Function; The link function to use. The default is the
canonical arctangent link.}
}
\value{
A numeric matrix containing a dataset sampled according to the
  circular GLM model. The first column \code{th} represents the circular
  outcome in radians. The following columns represent the linear predictors
  and are named \code{l1}, \code{l2}, ... . The following columns represent
  the categorical predictors and are named \code{c1}, \code{c2}, ... . The
  matrix also has attributes containing the true values of the parameters,
  the used link function, and a proportion \code{u} showing the proportion of
  the data that is on the semicircle closest to \code{beta_0}.
}
\description{
This function samples data according to the circular GLM model. A set of true
values for the parameters can be entered, and a dataset is returned that is
drawn from the corresponding model. The link function can also be selected.
}
\details{
This function can also be used as a wrapper for sampling von Mises data, if
\code{nconpred = 0}, \code{ncatpred = 0}. Then, \code{beta_0} is the mean of
the von Mises distribution and \code{residkappa} is the concentration
parameter \eqn{\kappa}.

In order to make this function more useful in simulations, the true
parameters are also added to the data set that is returned as attributes.
}
\examples{

# Von Mises data with mean 2, kappa 3.
generateCircGLMData(truebeta0 = 2, residkappa = 3,
                    nconpred = 0, ncatpred = 0)

# circGLM data
generateCircGLMData(n = 20, nconpred = 4, truebeta = c(0, 0.4, 0.2, 0.05))

}
