% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcRLsplineML.R
\name{CalcRLsplineML}
\alias{CalcRLsplineML}
\title{Calculate T-year levels for spline ML model}
\usage{
CalcRLsplineML(
  Data,
  drc,
  h,
  xiBoot,
  sigBoot,
  TTs = c(100, 10000),
  thetaGrid = 1:360,
  timeRange,
  thr
)
}
\arguments{
\item{Data}{Response variable}

\item{drc}{Directional covariate}

\item{h}{Bandwidth value}

\item{xiBoot}{Bootstrap estimates for EVI}

\item{sigBoot}{Bootstrap estimates for shape}

\item{TTs}{T-year levels. For example, TTs = c(100, 10000).}

\item{thetaGrid}{Grid values at which the estimation is performed}

\item{timeRange}{Time range of the sample}

\item{thr}{Threshold values along thetaGrid}
}
\value{
List including bootstrap estimates of T-year levels.
}
\description{
Calculate T-year levels for spline ML model
}
\examples{
## See also examples in vignettes:
# vignette("localMethods", package = "circularEV")
# vignette("splineML", package = "circularEV")
}
\seealso{
\code{\link{SplineML}} for examples.
}
