% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_lookup.R
\name{oc_lookup}
\alias{oc_lookup}
\alias{oc_doi2ids}
\alias{oc_pmid2ids}
\alias{oc_pmcid2ids}
\title{Methods for getting IDs from other IDs}
\usage{
oc_doi2ids(id, ...)

oc_pmid2ids(id, ...)

oc_pmcid2ids(id, ...)
}
\arguments{
\item{id}{One or more digital object identifiers (DOI),
PMID, or PMCID, depending on the function}

\item{...}{curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\value{
data.frame, with four columns:
\itemize{
\item doi: digital object identifier
\item pmid: pubmed identifier
\item pmcid: pubmed central identifier
\item paper: open citations corpus url
}

An empty data.frame (no columns or rows) when no results found

Column order will always be the same; note though that some
columns may be missing if, for example, there's no PMID for
a DOI search.
}
\description{
Methods for getting IDs from other IDs
}
\examples{
if (crul::ok('http://opencitations.net/sparql')) {
oc_doi2ids("10.1097/igc.0000000000000609")
oc_doi2ids('10.1093/biomet/80.3.527')
oc_doi2ids('10.1093/biomet/79.3.531')
oc_pmid2ids("26645990")
oc_pmcid2ids("PMC4679344")

oc_doi2ids(id = oc_dois[1:3])
oc_pmid2ids(id = oc_pmids[1:3])
oc_pmcid2ids(id = oc_pmcids[1:3])
}
}
