% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaExplain.R
\name{ciu.meta.explain}
\alias{ciu.meta.explain}
\title{ciu.meta.explain}
\usage{
ciu.meta.explain(
  ciu,
  instance,
  ind.inputs = NULL,
  in.min.max.limits = NULL,
  n.samples = 100,
  concepts.to.explain = NULL,
  target.concept = NULL,
  target.ciu = NULL
)
}
\arguments{
\item{ciu}{\code{ciu} object as created with \link{ciu} function (not to be confused
with \code{CIU} object as created by \link{ciu.new}).}

\item{instance}{Input values for the instance to explain. Should be a
\link{data.frame} even though a \code{vector} or \code{matrix} might work too if input
names and other needed metadata can be deduced from the dataset or other
parameters given to \code{\link{ciu.new}}.}

\item{ind.inputs}{Indices of input features to explain (the set {i} in CIU
formulae)}

\item{in.min.max.limits}{\link{data.frame} or \link{matrix} with one row per output
and two columns, where the first column indicates the minimal value and the
second column the maximal value for that output. ONLY NEEDED HERE IF not
given as parameter to \link{ciu.new} or if the limits are different for this
specific instance than the default ones.}

\item{n.samples}{How many instances to generate for estimating CI and CU.
For inputs of type \link{factor}, all possible combinations of input values
are generated, so this parameter only influences how many instances are
(at least) generated for continuous-valued inputs.}

\item{concepts.to.explain}{List of input feature concepts to explain, as defined
by vocabulary provided as argument to \link{ciu.new}. If \code{ind.inputs=NULL},
then use \code{concepts.to.explain} instead. If both are \code{NULL}, then use all inputs.}

\item{target.concept}{If provided, then calculate CIU of inputs
\code{ind.inputs.to.explain} relative to the given concept rather than
relative to the actual output(s). \code{ind.inputs.to.explain} should
normally be a subset (or all) of the inputs that \code{target.concept}
consists of, even though that not required by the CIU calculation.
If a \code{target.ciu} is provided, then the \code{target.concept} doesn't have to
be included in the \code{vocabulary} gives as parameter to \link{ciu.new}
(at least for the moment).}

\item{target.ciu}{\code{ciu.result} object previously calculated for
\code{target.concept}. If a \code{target.concept} is provided but \code{target.ciu=NULL},
then \code{target.ciu} is estimated by a call to \link{ciu.explain} with the
\code{n.samples} value given as a parameter to this call. It may be useful
to provide \code{target.ciu} if it should be estimated using some other
(typically greater) value for \code{n.samples} than the default one, or if it
has already been calculated for some reason.}
}
\value{
An object of class \code{ciu.meta.result}.
}
\description{
ciu.meta.explain
}
\examples{
# Explaining the classification of an Iris instance with lda model.
# We use a versicolor (instance 100).
library(MASS)
test.ind <- 100
iris_test <- iris[test.ind, 1:4]
iris_train <- iris[-test.ind, 1:4]
iris_lab <- iris[[5]][-test.ind]
model <- lda(iris_train, iris_lab)

# Create CIU object
ciu <- ciu.new(model, Species~., iris)

# Get ciu.meta.result. This can either be 'ciu$meta.explain(...)'
# or 'ciu.meta.explain(ciu, ...)'
ciu.meta <- ciu$meta.explain(iris_test)

# Use same result for different visualisations.
ciu$ggplot.col.ciu(ciu.meta = ciu.meta)
ciu$barplot.ciu(ind.output = 2, ciu.meta = ciu.meta)
ciu$pie.ciu(ind.output = 2, ciu.meta = ciu.meta)

# Same with Boston Housing data set.
library(caret)
gbm <- train(medv ~ ., Boston, method="gbm", trControl=trainControl(method="cv", number=10))
ciu <- ciu.new(gbm, medv~., Boston)
instance <- Boston[370,1:13]
ciu.meta <- ciu$meta.explain(instance)
ciu$barplot.ciu(ciu.meta = ciu.meta, sort = "CI")
ciu$pie.ciu(ciu.meta = ciu.meta)
ciu$ggplot.col.ciu(ciu.meta = ciu.meta)

}
\author{
Kary Främling
}
