% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{workflows_list_executions}
\alias{workflows_list_executions}
\title{List workflow executions}
\usage{
workflows_list_executions(id, limit = NULL, page_num = NULL, order = NULL,
  order_dir = NULL)
}
\arguments{
\item{id}{integer required. The ID for this workflow.}

\item{limit}{integer optional. Number of results to return. Defaults to 20. Maximum allowed is 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to id. Must be one of: id, updated_at, created_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID for this workflow execution.}
\item{state}{string, The state of this workflow execution.}
\item{mistralState}{string, The state of this workflow as reported by mistral. One of running, paused, success, error, or cancelled}
\item{mistralStateInfo}{string, The state info of this workflow as reported by mistral.}
\item{user}{object, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{startedAt}{string, The time this execution started.}
\item{finishedAt}{string, The time this execution finished.}
\item{createdAt}{string, The time this execution was created.}
\item{updatedAt}{string, The time this execution was last updated.}
}
\description{
List workflow executions
}
