% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{enhancements_get_person_matching}
\alias{enhancements_get_person_matching}
\title{Get a Person Matching Enhancement}
\usage{
enhancements_get_person_matching(id)
}
\arguments{
\item{id}{integer required.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID for the enhancement.}
\item{name}{string, The name of the enhancement.}
\item{type}{string, The type of the enhancement (e.g CASS-NCOA)}
\item{createdAt}{string, The time this enhancement was created.}
\item{updatedAt}{string, The time the enhancement was last updated.}
\item{author}{object, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{state}{string, The status of the enhancement's last run}
\item{schedule}{object, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the object is scheduled
\item scheduledDays array, Day based on numeric value starting at 0 for Sunday
\item scheduledHours array, Hours of the day it is scheduled on
\item scheduledMinutes array, Minutes of the day it is scheduled on
\item scheduledRunsPerHour integer, Alternative to scheduled minutes, number of times to run per hour
}}
\item{parentId}{integer, Parent ID that triggers this enhancement.}
\item{notifications}{object, A list containing the following elements: 
\itemize{
\item urls array, URLs to receive a POST request at job completion
\item successEmailSubject string, Custom subject line for success e-mail.
\item successEmailBody string, Custom body text for success e-mail, written in Markdown.
\item successEmailAddresses array, Addresses to notify by e-mail when the job completes successfully.
\item successEmailFromName string, Name from which success emails are sent; defaults to "Civis."
\item successEmailReplyTo string, Address for replies to success emails; defaults to the author of the job.
\item failureEmailAddresses array, Addresses to notify by e-mail when the job fails.
\item stallWarningMinutes integer, Stall warning emails will be sent after this amount of minutes.
\item successOn boolean, If success email notifications are on.
\item failureOn boolean, If failure email notifications are on.
}}
\item{runningAs}{object, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{configuration}{object, A list containing the following elements: 
\itemize{
\item task string, The type of person matching task. Options are: "table_to_table", "dedupe_table", or "table_to_civis_data".
\item source string, The input source of your data. Options are: "redshift" or "s3".
\item inputDatabaseName string, The Redshift database name for input data.
\item inputSchema string, The schema name for the input data.
\item inputTable string, The table name for the input data.
\item inputFileId string, The ID of the input S3 file.
\item inputFieldMapping string, The column mapping for the input in JSON or YAML.
\item inputFileHeaders string, Provide your headers in a list if the first row of your input does not have the headers, and make them JSON-decodable. For example: ["col1","col2","col3"].
\item targetDatabaseName string, The Redshift database for target data.
\item targetSchema string, The schema for target data.
\item targetTable string, The table for target data.
\item targetFieldMapping string, The column mapping for the target in JSON or YAML.
\item targetFileId string, The ID of the target S3 file.
\item matchTargetId integer, The ID of the match target.
\item matchDatabaseName string, The Redshift database for the match output table.
\item matchSchema string, The schema for the match output table.
\item matchTable string, The name of the match output table.
\item matchCsvFilename string, The name of the match output file.
\item matchSourceIdCol string, The name of the column in the output table that will hold the id from the source for each match.
\item matchTargetIdCol string, The name the column in the output table that will hold the id from the target for each match.
\item maxMatches integer, The maximum number of matches to return.
\item threshold number, The score threshold (between 0 and 1).
}}
}
\description{
Get a Person Matching Enhancement
}
