% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/await.R
\name{get_error}
\alias{get_error}
\title{Get error data from civis_errors}
\usage{
get_error(x)
}
\arguments{
\item{x}{The error, usually from \code{tryCatch}}
}
\value{
A list containing
 \item{f}{The function}
 \item{args}{A list of named arguments \code{f} was called with}
 \item{error}{The error message from platform (if any)}
 \item{status}{The status}
}
\description{
Get error data from civis_errors
}
\examples{
\dontrun{
 q_id <- queries_post(db_id, query, n_rows, cred_id)[["id"]]
 r <- tryCatch(await(queries_get, id = q_id), error = function(e) e)
 print(r)
 get_error(r)

 r <- try(await(queries_get, id = q_id))
 get_error(r)
 }
}
