% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{services_put_archive}
\alias{services_put_archive}
\title{Update the archive status of this object}
\usage{
services_put_archive(id, status)
}
\arguments{
\item{id}{integer required. The ID of the object.}

\item{status}{boolean required. The desired archived status of the object.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID for this Service.}
\item{name}{string, The name of this Service.}
\item{description}{string, The description of this Service.}
\item{user}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{type}{string, The type of this Service}
\item{dockerImageName}{string, The name of the docker image to pull from DockerHub.}
\item{dockerImageTag}{string, The tag of the docker image to pull from DockerHub (default: latest).}
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item runtimePlan string, Only affects the service when deployed. On Demand means that the service will be turned on when viewed and automatically turned off after periods of inactivity.  Specific Times means the service will be on when scheduled. Always On means the deployed service will always be on.
\item recurrences array, List of day-hour combinations this item is scheduled for
}}
\item{timeZone}{string, }
\item{replicas}{integer, The number of Service replicas to deploy. When maxReplicas is set, this field defines the minimum number of replicas to deploy.}
\item{maxReplicas}{integer, The maximum number of Service replicas to deploy. Defining this field enables autoscaling.}
\item{instanceType}{string, The EC2 instance type to deploy to.}
\item{memory}{integer, The amount of memory allocated to each replica of the Service.}
\item{cpu}{integer, The amount of cpu allocated to each replica of the the Service.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{credentials}{array, A list of credential IDs to pass to the Service.}
\item{apiKeyId}{integer, API key id of user}
\item{gitRepoUrl}{string, The url for the git repo where the Service code lives.}
\item{gitRepoRef}{string, The git reference to use when pulling code from the repo.}
\item{gitPathDir}{string, The path to the Service code within the git repo. If unspecified, the root directory will be used.}
\item{reportId}{integer, The ID of the associated report.}
\item{currentDeployment}{list, A list containing the following elements: 
\itemize{
\item deploymentId integer, The ID for this deployment.
\item userId integer, The ID of the owner.
\item host string, Domain of the deployment.
\item name string, Name of the deployment.
\item dockerImageName string, The name of the docker image to pull from DockerHub.
\item dockerImageTag string, The tag of the docker image to pull from DockerHub (default: latest).
\item displayUrl string, A signed URL for viewing the deployed item.
\item instanceType string, The EC2 instance type requested for the deployment.
\item memory integer, The memory allocated to the deployment.
\item cpu integer, The cpu allocated to the deployment.
\item state string, The state of the deployment.
\item stateMessage string, A detailed description of the state.
\item createdAt string, 
\item updatedAt string, 
\item published boolean, 
\item serviceId integer, The ID of owning Service
}}
\item{previewDeployment}{list, A list containing the following elements: 
\itemize{
\item deploymentId integer, The ID for this deployment.
\item userId integer, The ID of the owner.
\item host string, Domain of the deployment.
\item name string, Name of the deployment.
\item dockerImageName string, The name of the docker image to pull from DockerHub.
\item dockerImageTag string, The tag of the docker image to pull from DockerHub (default: latest).
\item displayUrl string, A signed URL for viewing the deployed item.
\item instanceType string, The EC2 instance type requested for the deployment.
\item memory integer, The memory allocated to the deployment.
\item cpu integer, The cpu allocated to the deployment.
\item state string, The state of the deployment.
\item stateMessage string, A detailed description of the state.
\item createdAt string, 
\item updatedAt string, 
\item published boolean, 
\item serviceId integer, The ID of owning Service
}}
\item{currentUrl}{string, The URL that the service is hosted at.}
\item{previewUrl}{string, The URL that previews of the service are hosted at.}
\item{environmentVariables}{list, Environment Variables to be passed into the Service.}
\item{notifications}{list, A list containing the following elements: 
\itemize{
\item failureEmailAddresses array, Addresses to notify by e-mail when the service fails.
\item failureOn boolean, If failure email notifications are on
}}
\item{archived}{string, The archival status of the requested item(s).}
\item{hidden}{boolean, The hidden status of the item.}
}
\description{
Update the archive status of this object
}
