% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{transfer_table}
\alias{transfer_table}
\title{Transfer a table from one location to another.}
\usage{
transfer_table(source_db, dest_db, source_table, dest_table,
  job_name = NULL, source_credential_id = NULL,
  dest_credential_id = NULL, interval = NULL, verbose = FALSE,
  advanced_options = NULL)
}
\arguments{
\item{source_db}{string or int, The name of the database where the source table is located. 
Optionally, could be the database ID.}

\item{dest_db}{string or int, The name of the database where the table will be transfered.
Optionally, could be the database ID.}

\item{source_table}{string, Full name of the table to transfer,
e.g., \code{"schema.table"}.}

\item{dest_table}{string, Full name of the table in the destination database,
e.g., \code{"schema.table"}.}

\item{job_name}{string, optional, A name to give the job. 
If omitted, a random job name will be used.}

\item{source_credential_id}{string or int, Optional credential ID 
for the source database. If \code{NULL}, the default credential will be used.}

\item{dest_credential_id}{string or int, Optional credential ID 
for the source database. If \code{NULL}, the default credential will be used.}

\item{interval}{Number of seconds to wait between checks for job completion. 
If \code{NULL}, the default exponential backoff from \code{await} will be used.}

\item{verbose}{bool, Set to TRUE to print intermediate progress indicators.}

\item{advanced_options}{A list of advanced options for the sync. See \code{\link{imports_post_syncs}} for
details.}
}
\value{
A \code{civis_api} object.
}
\description{
Transfer a table from one location to another.
}
\examples{
\dontrun{
transfer_table(source_db='Cluster A', dest_db='Cluster B',
               source_table='schma.tbl', dest_table='schma.tbl')
}
}
\seealso{
Other tables: \code{\link{get_table_id}},
  \code{\link{refresh_table}}
}
\concept{tables}
