% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{download_civis}
\alias{download_civis}
\alias{download_civis.character}
\alias{download_civis.sql}
\alias{download_civis.numeric}
\title{Download a table or a file from the Civis Platform to local disk}
\usage{
download_civis(x, ...)

\method{download_civis}{character}(x, database = NULL, file,
  overwrite = FALSE, progress = FALSE, split = FALSE,
  job_name = NULL, hidden = TRUE, verbose = FALSE, ...)

\method{download_civis}{sql}(x, database = NULL, file,
  overwrite = FALSE, progress = FALSE, split = FALSE,
  job_name = NULL, hidden = TRUE, verbose = FALSE, ...)

\method{download_civis}{numeric}(x, file, overwrite = FALSE,
  progress = FALSE, ...)
}
\arguments{
\item{x}{\code{"schema.table"}, \code{sql("query")}, or a file id.}

\item{...}{Currently ignored.}

\item{database}{string, The database. If \code{NULL}, tries to use the default database.}

\item{file}{string, The file to write to.}

\item{overwrite}{logical, Whether to overwrite the existing \code{file}.}

\item{progress}{logical, Whether to display a progress bar.}

\item{split}{logical, Whether to download a big table by splitting it into multiple
CSV parts first. See \code{\link{civis_to_multifile_csv}} for details.}

\item{job_name}{string, Name of the job (default: \code{"Civis Download Via R Client"}).}

\item{hidden}{logical, Whether the job is hidden on Platform.}

\item{verbose}{logical, Whether to print detailed updates of job status.}
}
\value{
The file where the downloaded files or tables are written to.
It is returned invisibly.
}
\description{
\code{download_civis} downloads a file based on the type of its first
argument, which can be a string \code{"schema.table"},
a SQL query \code{sql(...)}, or a numeric file ID.

A table or a query from Redshift will be downloaded onto disk as a CSV.
A file from Platform files endpoint will be downloaded as is.

A default database can be set using \code{options(civis.default_db = "my_database")}.
If there is only one database available,
this database will automatically be used as the default.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: Download a table from Redshift to disk as CSV.

\item \code{sql}: Download the result of a SQL query from Redshift to disk as CSV.

\item \code{numeric}: Download a file from Platform files endpoint to disk.
}}

\examples{
\dontrun{
# Download all columns in a single table into a CSV
download_civis("schema.table", database = "my_database",
               file = "~/Downloads/my_table.csv")

# Download data from a SQL select statement into a CSV
query <- sql("SELECT * FROM table JOIN other_table USING id WHERE var1 < 23")
download_civis(query, database = "my_database",
               file = "~/Downloads/my_table.csv")

# Set a default database
options(civis.default_db = "my_database")

# Download any file from the files endpoint.
file_id <- write_civis_file(df)
download_civis(file_id, file = "df.rds", progress = TRUE)
df2 <- readRDS("df.rds")
identical(df, df2)
}
}
\seealso{
Other io: \code{\link{query_civis_file}},
  \code{\link{query_civis}}, \code{\link{read_civis}},
  \code{\link{write_civis_file}}, \code{\link{write_civis}}
}
\concept{io}
