% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{scripts_list_sql_runs}
\alias{scripts_list_sql_runs}
\title{List runs for the given sql}
\usage{
scripts_list_sql_runs(
  id,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{id}{integer required. The ID of the sql.}

\item{limit}{integer optional. Number of results to return. Defaults to 20. Maximum allowed is 100.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to id. Must be one of: id.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID of this run.}
\item{sqlId}{integer, The ID of this sql.}
\item{state}{string, The state of this run.}
\item{isCancelRequested}{boolean, True if run cancel requested, else false.}
\item{startedAt}{string, The time the last run started.}
\item{finishedAt}{string, The time that this run finished.}
\item{error}{string, The error message for this run, if present.}
\item{output}{array, An array containing the following fields: 
\itemize{
\item outputName string, The name of the output file.
\item fileId integer, The unique ID of the output file.
\item path string, The temporary link to download this output file, valid for 36 hours.
}}
}
\description{
List runs for the given sql
}
