% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{exports_get_files_csv}
\alias{exports_get_files_csv}
\title{Get a CSV Export}
\usage{
exports_get_files_csv(id)
}
\arguments{
\item{id}{integer required.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of this Csv Export job.}
\item{name}{string, The name of this Csv Export job.}
\item{source}{list, A list containing the following elements: 
\itemize{
\item sql string, The SQL query for this Csv Export job
\item remoteHostId integer, The ID of the destination database host.
\item credentialId integer, The ID of the credentials for the destination database.
}}
\item{destination}{list, A list containing the following elements: 
\itemize{
\item filenamePrefix string, The prefix of the name of the file returned to the user.
\item storagePath list . A list containing the following elements: 
\itemize{
\item filePath string, The path within the bucket where the exported file will be saved. E.g. the file_path for "s3://mybucket/files/all/" would be "/files/all/"
\item storageHostId integer, The ID of the destination storage host.
\item credentialId integer, The ID of the credentials for the destination storage host.
\item existingFiles string, Notifies the job of what to do in the case that the exported file already exists at the provided path.One of: fail, append, overwrite. Default: fail. If "append" is specified,the new file will always be added to the provided path. If "overwrite" is specifiedall existing files at the provided path will be deleted and the new file will be added.By default, or if "fail" is specified, the export will fail if a file exists at the provided path.
}
}}
\item{includeHeader}{boolean, A boolean value indicating whether or not the header should be included. Defaults to true.}
\item{compression}{string, The compression of the output file. Valid arguments are "gzip" and "none". Defaults to "gzip".}
\item{columnDelimiter}{string, The column delimiter for the output file. Valid arguments are "comma", "tab", and "pipe". Defaults to "comma".}
\item{hidden}{boolean, A boolean value indicating whether or not this request should be hidden. Defaults to false.}
\item{forceMultifile}{boolean, Whether or not the csv should be split into multiple files. Default: false}
\item{maxFileSize}{integer, The max file size, in MB, created files will be. Only available when force_multifile is true. }
}
\description{
Get a CSV Export
}
