% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{clusters_list_kubernetes_partitions}
\alias{clusters_list_kubernetes_partitions}
\title{List Cluster Partitions for given cluster}
\usage{
clusters_list_kubernetes_partitions(id, include_usage_stats = NULL)
}
\arguments{
\item{id}{integer required.}

\item{include_usage_stats}{boolean optional. When true, usage stats are returned in instance config objects. Defaults to false.}
}
\value{
An array containing the following fields:
\item{clusterPartitionId}{integer, The ID of this cluster partition.}
\item{name}{string, The name of the cluster partition.}
\item{labels}{array, Labels associated with this partition.}
\item{instanceConfigs}{array, An array containing the following fields: 
\itemize{
\item instanceConfigId integer, The ID of this InstanceConfig.
\item instanceType string, An EC2 instance type. Possible values include t2.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m5.12xlarge, and c5.18xlarge.
\item minInstances integer, The minimum number of instances of that type in this cluster.
\item maxInstances integer, The maximum number of instances of that type in this cluster.
\item instanceMaxMemory integer, The amount of memory (RAM) available to a single instance of that type in megabytes.
\item instanceMaxCpu integer, The number of processor shares available to a single instance of that type in millicores.
\item instanceMaxDisk integer, The amount of disk available to a single instance of that type in gigabytes.
\item usageStats object, 
}}
\item{defaultInstanceConfigId}{integer, The id of the InstanceConfig that is the default for this partition.}
}
\description{
List Cluster Partitions for given cluster
}
