% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{jobs_list}
\alias{jobs_list}
\title{List Jobs}
\usage{
jobs_list(
  state = NULL,
  type = NULL,
  q = NULL,
  permission = NULL,
  scheduled = NULL,
  hidden = NULL,
  archived = NULL,
  author = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{state}{string optional. The job's state. One or more of queued, running, succeeded, failed, and cancelled. Specify multiple values as a comma-separated list (e.g., "A,B").}

\item{type}{string optional. The job's type. Specify multiple values as a comma-separated list (e.g., "A,B").}

\item{q}{string optional. Query string to search on the id, name, and job type.}

\item{permission}{string optional. A permissions string, one of "read", "write", or "manage". Lists only jobs for which the current user has that permission.}

\item{scheduled}{boolean optional. If the item is scheduled.}

\item{hidden}{boolean optional. If specified to be true, returns hidden items. Defaults to false, returning non-hidden items.}

\item{archived}{string optional. The archival status of the requested item(s).}

\item{author}{string optional. If specified, return items from any of these authors. It accepts a comma-separated list of user IDs.}

\item{limit}{integer optional. Number of results to return. Defaults to its maximum of 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to updated_at. Must be one of: updated_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, }
\item{name}{string, }
\item{type}{string, }
\item{fromTemplateId}{integer, }
\item{state}{string, Whether the job is idle, queued, running, cancelled, or failed.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{archived}{string, The archival status of the requested item(s).}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Days of the week, based on numeric value starting at 0 for Sunday. Mutually exclusive with scheduledDaysOfMonth
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Deprecated in favor of scheduled minutes.
\item scheduledDaysOfMonth array, Days of the month it is scheduled on, mutually exclusive with scheduledDays.
}}
}
\description{
List Jobs
}
