#' Stop the cluster if snow::makeCluster() was used, but nothing needed if doMC
#' was used.
#'
#' @param cluster_obj Cluster object generated by parallelize()
#' @param verbose If T display extra information during execution.
#' @export
stop_cluster = function(cluster_obj, verbose = FALSE) {
  # Check if this cluster was created using parallel:makeCluster
  if (inherits(cluster_obj, "cluster")) {
    parallel::stopCluster(cluster_obj)
  } else {
    if (verbose) {
      cat("No cluster shutdown required.\n")
    }
    invisible()
  }
}
