% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboard_activity_list.R
\name{dashboard_activity_list}
\alias{dashboard_activity_list}
\title{Authorized user's dashboard activity stream}
\usage{
dashboard_activity_list(limit = 31, offset = 0,
  url = get_default_url(), key = get_default_key(), as = "list", ...)
}
\arguments{
\item{limit}{(integer) The maximum number of activities to return (optional).
Default: 31}

\item{offset}{(integer) Where to start getting activity items from (optional).
Default: 0}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[httr]{POST}} (optional)}
}
\description{
Authorized user's dashboard activity stream
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "https://demo.ckan.org/", key = getOption("ckan_demo_key"))

# get activity
(res <- dashboard_activity_list())
}
}
