% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_create.R
\name{package_create}
\alias{package_create}
\title{Create a package}
\usage{
package_create(
  name = NULL,
  title = NULL,
  private = FALSE,
  author = NULL,
  author_email = NULL,
  maintainer = NULL,
  maintainer_email = NULL,
  license_id = NULL,
  notes = NULL,
  package_url = NULL,
  version = NULL,
  state = "active",
  type = NULL,
  resources = NULL,
  tags = NULL,
  extras = NULL,
  relationships_as_object = NULL,
  relationships_as_subject = NULL,
  groups = NULL,
  owner_org = NULL,
  url = get_default_url(),
  key = get_default_key(),
  as = "list",
  ...
)
}
\arguments{
\item{name}{(character) the name of the new dataset, must be between 2 and
100 characters long and contain only lowercase alphanumeric characters, -
and _, e.g. 'warandpeace'}

\item{title}{(character) the title of the dataset (optional, default: same
as name)}

\item{private}{(logical) whether the dataset should be private (optional,
default: \code{FALSE}), requires a value for \code{owner_org} if \code{TRUE}}

\item{author}{(character) the name of the dataset's author (optional)}

\item{author_email}{(character) the email address of the dataset's author
(optional)}

\item{maintainer}{(character) the name of the dataset's maintainer
(optional)}

\item{maintainer_email}{(character) the email address of the dataset's
maintainer (optional)}

\item{license_id}{(license id string) - the id of the dataset's license,
see license_list() for available values (optional)}

\item{notes}{(character) a description of the dataset (optional)}

\item{package_url}{(character) a URL for the dataset's source (optional)}

\item{version}{(string, no longer than 100 characters) - (optional)}

\item{state}{(character) the current state of the dataset, e.g. 'active'
or 'deleted', only active datasets show up in search results and other
lists of datasets, this parameter will be ignored if you are not authorized
to change the state of the dataset (optional, default: 'active')}

\item{type}{(character) the type of the dataset (optional), IDatasetForm
plugins associate themselves with different dataset types and provide custom
dataset handling behaviour for these types}

\item{resources}{(list of resource dictionaries) - the dataset's resources,
see \code{\link[=resource_create]{resource_create()}} for the format of resource dictionaries (optional)}

\item{tags}{(list of tag dictionaries) - the dataset's tags, see
\code{\link[=tag_create]{tag_create()}} for the format of tag dictionaries (optional)}

\item{extras}{(list of dataset extra dictionaries) - the dataset's extras
(optional), extras are arbitrary (key: value) metadata items that can be
added to datasets, each extra dictionary should have keys 'key' (a string),
'value' (a string)}

\item{relationships_as_object}{(list of relationship dictionaries) - see
\code{package_relationship_create} for the format of relationship dictionaries
(optional)}

\item{relationships_as_subject}{(list of relationship dictionaries) - see
\code{package_relationship_create} for the format of relationship dictionaries
(optional)}

\item{groups}{(list of dictionaries) - the groups to which the dataset
belongs (optional), each group dictionary should have one or more of the
following keys which identify an existing group: 'id' (the id of the group,
string), or 'name' (the name of the group, string), to see which groups
exist call \code{\link[=group_list]{group_list()}}}

\item{owner_org}{(character) the id of the dataset's owning organization,
see \code{\link[=organization_list]{organization_list()}} or \code{organization_list_for_user} for available
values (optional)}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
Create a package
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "https://demo.ckan.org/", key = getOption("ckan_demo_key"))

# create a package
## Example 1
(res <- package_create("foobar4", author="Jane Doe"))
res$author

## Example 2 - create package, add a resource
(res <- package_create("helloworld", author="Jane DOe"))

}
}
