% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clgeo_SummaryReport.R
\name{clgeo_SummaryReport}
\alias{clgeo_SummaryReport}
\title{clgeo_SummaryReport}
\usage{
clgeo_SummaryReport(report)
}
\arguments{
\item{report}{a report object as returned by\code{\link{clgeo_CollectionReport}}}
}
\value{
an object of class \code{table} giving the report summary. The summary
gives the counting by value for each of the report columns:
\itemize{
  \item \emph{type} eventual \pkg{rgeos} issue
  \item \emph{valid} geometry validity status (according to OGC specifications)
  \item \emph{issue_type} type of geometry issue
  \item \emph{error_msg} catched message when error raised about geometry
  \item \emph{warning_msg} catched message when warning raised about geometry
}
}
\description{
Function to get summary of a spatial data collection report returned by 
\code{\link{clgeo_CollectionReport}}
}
\examples{
 require(maptools)
 file <- system.file("extdata", "example.shp", package = "cleangeo")
 sp <- readShapePoly(file)
 
 report <- clgeo_CollectionReport(sp)
 clgeo_SummaryReport(report)
 
}
\seealso{
\code{\link{clgeo_CollectionReport}}
}
\author{
Emmanuel Blondel \email{emmanuel.blondel1@gmail.com}
}
\keyword{geometry}
\keyword{summary}
\keyword{validity}
