% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{world_climate}
\alias{world_climate}
\title{Climate data in the world}
\format{
A data frame with 41328 (3444 stations * 12 months) rows
and 11 variable:
\describe{
\item{no           }{Station no}
\item{month        }{Month}
\item{temperature  }{Mean temperature}
\item{precipitation}{Mean precipitation}
\item{station      }{Station name. To avoid duplication, including country name after station name. Can split by "_". Escaped by stringi::stri_escape_unicode().}
\item{country      }{Country name. Escaped by stringi::stri_escape_unicode().}
\item{latitude     }{Latitude. (degree)}
\item{NS           }{North or South.}
\item{longitude    }{Longitude. (degree)}
\item{WE           }{West or East.}
\item{altitude     }{Altitude (m)}
}
}
\usage{
world_climate
}
\description{
Climate data downloaded from Japan Meteorological Agency web pages.
URLs of each station are listed in data(station_links).
https://www.data.jma.go.jp/gmd/cpd/monitor/nrmlist/
}
\examples{
library(tidyverse)
data(world_climate)
world_climate \%>\%
  dplyr::mutate_all(stringi::stri_unescape_unicode)
}
\keyword{datasets}
