% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findStations.R
\name{cf_save_kml}
\alias{cf_save_kml}
\title{Save Clifro Station Information to a KML File}
\usage{
cf_save_kml(station, file_name = "my_stations_", file_path = ".")
}
\arguments{
\item{station}{\code{cfStation} object containing one or more stations}

\item{file_name}{file name for the resulting KML file}

\item{file_path}{file path for the resulting KML file}
}
\description{
Save \code{\link{cfStation}} object information to a KML file.
}
\details{
The \code{cf_save_kml} function is for \code{\link{cfStation}}
objects to allow for the spatial visualisation of the selected stations. The
resulting KML file is saved and can then be opened by programs like Google
Earth (TM). The resultant KML file has the station names and locations shown
with green markers for open and red markers for closed stations. The agent
numbers, network ID's and date ranges are contained within the descriptions
for each station.

If no file name is specified, unique names are produced in the current \R
working directory.
}
\note{
The \code{.kml} suffix is appended automatically if it isn't already
present in the \code{file_name} argument.
}
\examples{
\dontrun{
# A selection of four Auckland region stations down the East Coast to the
# upper Waitemata Harbour; Leigh 2 Ews, Warkworth Ews, Tiri Tiri Lighthouse
# and Henderson
my.stations = cf_station(17838, 1340, 1401, 12327)
my.stations

# Save these stations to a KML file
cf_save_kml(my.stations)

# Double click on the file to open with a default program (if available). All
# the markers are green, indicating all these stations are open.

# Where is the subscription-free Reefton Ews station?
cf_save_kml(cf_station(), file_name = "reeftonEWS")

# It's located in the sou'west quadrant of Reefton town, in the upper, western
# part of the South Island, NZ.

# Find all the open and closed Christchurch stations (using partial matching)
all.chch.st = cf_find_station("christ", status = "all", search = "region")

# How many stations in total?
nrow(all.chch.st)

# Save all the Christchurch stations
cf_save_kml(all.chch.st, file_name = "all_Chch_stations")
}
}
\seealso{
\code{\link{cf_station}} and \code{vignette("cfStation")} for
working with stations when the agent numbers are known, otherwise
\code{\link{cf_find_station}} and code{vignette("choose-station")} for
creating \code{cfStation} objects when the agent numbers are unknown.
}
