% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/climdex.r
\name{climdex.tx10p}
\alias{climdex.tx10p}
\title{Computation of these percentiles involves use of a boostrap procedure,
described below but described in more depth in [Zhang, 2005].}
\usage{
climdex.tx10p(ci, freq = c("monthly", "annual"))
}
\arguments{
\item{ci}{Object of type climdexInput.}

\item{freq}{Time frequency to aggregate to.}
}
\value{
A vector containing a timeseries containing values of the index on a
monthly or annual timescale.
}
\description{
Computation of these values outside of the base period involves comparing
the temperature data for each day with the corresponding percentiles for a 5
day running window surrounding that day. The resulting monthly series is
then the monthly percentage of values that meet the criteria.
}
\details{
Computation of these values inside the base period is more complicated. It
involves comparison of the daily temperature data with the corresponding day
of temperature data in each of (n - 1) sets of data. The sets consist of the
data for the base period with the current year replaced with each of the
other years. The results of these comparisons are then averaged to give a
value between 0 and 1. Finally, the resulting daily series is aggregated to
a monthly series by averaging these daily values and multiplying by 100 to
give a monthly percentile value.
}
\note{
These functions may calculate slightly different results than
fclimdex.

The bootstrapping method is not well defined for cases where the base data
contains numerous missing values.  Because of that, this code (and fclimdex)
are not very robust against missing values with respect to these indicies.
When computing percentiles inside the base period, both this implementation
and fclimdex do not divide through by the number of non-missing values when
aggregating the values inside the base period. Instead, they divide through
by the number of base years minus one. This will result in a negative bias
when missing values are present.
}
\examples{
library(PCICt)

## Create a climdexInput object from some data already loaded in and
## ready to go.

## Parse the dates into PCICt.
tmax.dates <- as.PCICt(do.call(paste, ec.1018935.tmax[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
tmin.dates <- as.PCICt(do.call(paste, ec.1018935.tmin[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")
prec.dates <- as.PCICt(do.call(paste, ec.1018935.prec[,c("year",
"jday")]), format="\%Y \%j", cal="gregorian")

## Load the data in.
ci <- climdexInput.raw(ec.1018935.tmax$MAX_TEMP,
ec.1018935.tmin$MIN_TEMP, ec.1018935.prec$ONE_DAY_PRECIPITATION,
tmax.dates, tmin.dates, prec.dates, base.range=c(1971, 2000))

## Create a monthly timeseries of the TX10p index.
tx10p <- climdex.tx10p(ci)
}
\references{
\url{http://etccdi.pacificclimate.org/list_27_indices.shtml}
}
\seealso{
\code{\link{climdexInput.raw}}, \code{\link{climdexInput.csv}}.
}
\keyword{climate}
\keyword{ts}

