\name{plot.emaxsimBobj}
\alias{plot.emaxsimBobj}

\title{ Plot dose response from a data set generated by emaxsimB }
\description{
Plot of population dose response curve, sample dose group means, 
posterior and posterior predictive intervals, and
the model-based estimated (posterior means) dose response curve.
}

\usage{
\method{plot}{emaxsimBobj}(
	x, clev=0.9, plotDif=FALSE, 
	plotPop=c('m','3','4'), 
	log=FALSE, plotResid=FALSE, 
	plot=TRUE, ... )
}

\arguments{
  \item{x}{Extracted data object from \code{\link{emaxsimB}} }
  \item{clev}{Level for posterior intervals }
  \item{plotDif}{When \code{TRUE}, the difference with placebo is plotted.}
  \item{plotPop}{When plotPop='m', the mean values at each dose in the
  designs are joined using linear interpolation.  Otherwise, the
	the population Emax parameters must be supplied with the
	data generator (see \link{FixedMean} or \link{RandEmax}).  If
	the Emax parameters are not available, linear interpolation is used.}
  \item{log}{Not implemented}
  \item{plotResid}{Not implemented}
  \item{plot}{Return plotting output without plotting.}  
  \item{\dots}{Other plot parameters.  See \code{plot.fitEmaxB} for details  }
}

\note{The estimated curve is the posterior mean evaluated along a grid of
dose values.}

\examples{
\dontrun{

## emaxsimB changes the random number seed

nsim<-50
idmax<-5
doselev<-c(0,5,25,50,100)
n<-c(78,81,81,81,77)
Ndose<-length(doselev)

### population parameters for simulation
e0<-2.465375 
ed50<-67.481113 
emax<-4.127726
sdy<-7.967897
pop<-c(log(ed50),emax,e0)    
meanlev<-emaxfun(doselev,pop)  

###FixedMean is specialized constructor function for emaxsim
gen<-FixedMean(n,doselev,meanlev,sdy)  


prior<-prior.control(epmu=0,epsd=30,emaxmu=0,emaxsd=30,p50=50,sigmalow=0.1,
		sigmaup=30,edDF=5)
mcmc<-mcmc.control(chains=1,warmup=500,iter=5000,seed=53453,propInit=0.15,adapt_delta = 0.95)

D1 <- emaxsimB(nsim,gen, prior, modType=3,mcmc=mcmc,check=FALSE)

plot(D1[2])
}
}








