% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting-render_clinDataReviewReport.R
\name{renderInNewSession}
\alias{renderInNewSession}
\title{Render a rmarkdown doc in a new session,
with the possibility to save output in a log file,
and saving also session information.}
\usage{
renderInNewSession(
  input,
  run_pandoc = FALSE,
  output_options = list(keep_md = TRUE),
  encoding = "UTF-8",
  params = NULL,
  ...
)
}
\arguments{
\item{input}{Input file to be rendered.}

\item{run_pandoc}{Logical, if TRUE (FALSE by default)
convert Md to specified output with pandoc.}

\item{output_options}{List of output options,
by default 'keep_md = TRUE' (keep Markdown file)}

\item{encoding}{String with encoding, 'UTF-8' by default.}

\item{params}{List with input parameters for this document.\cr
These parameters should be accessed in the Rmd document via
\code{params$...}.\cr
These parameters will be saved to a RDS file and imported 
during the report rendering.}

\item{...}{Any extra parameters passed to \code{\link[rmarkdown]{render}}}
}
\value{
Output of the function executed in the new R session 
with additional attribute: 'sessionInfo' containing
the details of the session information in the separated R session.
If the report fails, an error message is returned.
}
\description{
Note: this function is inspired from \code{xfun::Rscript_call}
}
\author{
Laure Cougnaud
}
