% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{posterior_predict.clmstan}
\alias{posterior_predict.clmstan}
\title{Posterior predictive distribution for clmstan objects}
\usage{
posterior_predict.clmstan(object, newdata = NULL, ndraws = NULL, ...)
}
\arguments{
\item{object}{A \code{clmstan} object returned by \code{\link[=clm_stan]{clm_stan()}}.}

\item{newdata}{Optional data frame for prediction. If \code{NULL} (default),
predictions are made for the original training data.}

\item{ndraws}{Number of posterior draws to use. If \code{NULL} (default),
all available draws are used.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
An integer matrix of dimension S x N containing predicted
categories (1 to K), where S is the number of posterior draws and
N is the number of observations.
}
\description{
Draws from the posterior predictive distribution. For each posterior
sample, a predicted category is sampled from the categorical distribution
with the predicted probabilities.
}
\seealso{
\code{\link[=predict.clmstan]{predict.clmstan()}}, \code{\link[=fitted.clmstan]{fitted.clmstan()}}
}
