% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-month-weekday.R
\name{seq.clock_year_month_weekday}
\alias{seq.clock_year_month_weekday}
\title{Sequences: year-month-weekday}
\usage{
\method{seq}{clock_year_month_weekday}(from, to = NULL, by = NULL, length.out = NULL, along.with = NULL, ...)
}
\arguments{
\item{from}{\verb{[clock_year_month_weekday(1)]}

A \code{"year"} or \code{"month"} precision year-month-weekday to start the sequence
from.

\code{from} is always included in the result.}

\item{to}{\verb{[clock_year_month_weekday(1) / NULL]}

A \code{"year"} or \code{"month"} precision year-month-weekday to stop the sequence
at.

\code{to} is cast to the type of \code{from}.

\code{to} is only included in the result if the resulting sequence divides
the distance between \code{from} and \code{to} exactly.}

\item{by}{\verb{[integer(1) / clock_duration(1) / NULL]}

The unit to increment the sequence by.

If \code{to < from}, then \code{by} must be positive.

If \code{to > from}, then \code{by} must be negative.

If \code{by} is an integer, it is transformed into a duration with the
precision of \code{from}.

If \code{by} is a duration, it is cast to the type of \code{from}.}

\item{length.out}{\verb{[positive integer(1) / NULL]}

The length of the resulting sequence.

If specified, \code{along.with} must be \code{NULL}.}

\item{along.with}{\verb{[vector / NULL]}

A vector who's length determines the length of the resulting sequence.

Equivalent to \code{length.out = vec_size(along.with)}.

If specified, \code{length.out} must be \code{NULL}.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A sequence with the type of \code{from}.
}
\description{
This is a year-month-weekday method for the \code{\link[=seq]{seq()}} generic.

Sequences can only be generated for \code{"year"} and \code{"month"} precision
year-month-weekday vectors.

When calling \code{seq()}, exactly two of the following must be specified:
\itemize{
\item \code{to}
\item \code{by}
\item Either \code{length.out} or \code{along.with}
}
}
\examples{
# Monthly sequence
x <- seq(year_month_weekday(2019, 1), year_month_weekday(2020, 12), by = 1)
x

# Which we can then set the indexed weekday of
set_day(x, clock_weekdays$sunday, index = "last")
}
