/*
 * Decompiled with CFR 0.152.
 */
package cloudrmpi;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.LocalPortForwarder;
import com.norbl.util.ArgvUtil;
import com.norbl.util.StringUtil;
import com.norbl.util.ssh.ConnectFailureException;
import com.norbl.util.ssh.Ssh;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import rreval.AppCmd;
import rreval.ConnectionR;
import rreval.Message;
import rreval.MessageType;
import rreval.RReaderEOFException;
import rreval.Verbose;

public class PortForwardingServer {
    public static final int CLIENT_PORT_DEFAULT = 4470;
    public static long SSH_WAIT_TIME = 5000L;
    public static final String ARGV_PORT = "port";
    public static final String ARGV_PEMFILE = "pemfile";
    public static final String CMD_LABEL_PORT_LOCAL = "portlocal";
    public static final String CMD_LABEL_PORT_REMOTE = "portremote";
    public static final String CMD_LABEL_PEMFILE = "pemfile";
    public static final String CMD_LABEL_HOST = "host";
    public static final String CMD_LABEL_USER_NAME = "username";
    int port;
    boolean keepRunning;
    ServerSocket serverSocket;
    List<MessageHandler> messageHandlers;
    HashMap<String, Pf> pfHt;

    public PortForwardingServer(int port) {
        this.port = port;
        this.messageHandlers = new ArrayList<MessageHandler>();
        this.pfHt = new HashMap();
    }

    public static void main(String[] argv) {
        int port = ArgvUtil.getIntVal((String[])argv, (String)ARGV_PORT, (int)4470);
        PortForwardingServer pfs = new PortForwardingServer(port);
        Verbose.verbose = Boolean.parseBoolean(ArgvUtil.getVal((String[])argv, (String)"verbose", (String)"true"));
        pfs.launch();
    }

    public void launch() {
        try {
            this.keepRunning = true;
            this.serverSocket = new ServerSocket(this.port);
            while (this.keepRunning) {
                try {
                    Socket s = this.serverSocket.accept();
                    MessageHandler h = new MessageHandler(s);
                    this.messageHandlers.add(h);
                    new Thread(h).start();
                    Verbose.show((String)("... R client has connected on port " + this.port));
                }
                catch (Exception xxx) {
                    Verbose.show((String)"PortForwardingServer.launch(): ", (Exception)xxx);
                }
            }
        }
        catch (Exception xxx) {
            Verbose.show((String)"PortForwardingServer.launch(): ", (Exception)xxx);
        }
    }

    String buildPfKey(String hostName, String userName) {
        return userName + "@" + hostName;
    }

    class Pf {
        String hostName;
        String userName;
        int portLocal;
        int portRemote;
        File pemFile;
        Connection con;
        LocalPortForwarder portForwarder;

        Pf(String hostName, String userName, int portRemote, File pemFile, int portLocal) throws IOException, ConnectFailureException {
            this.hostName = hostName;
            this.userName = userName;
            this.portRemote = portRemote;
            this.pemFile = pemFile;
            this.portLocal = portLocal;
            this.con = Ssh.connect((String)hostName, (String)userName, (File)pemFile, (long)SSH_WAIT_TIME);
            this.portForwarder = this.con.createLocalPortForwarder(portLocal, "localhost", portRemote);
            Verbose.show((String)("PortForwarind server: started port forwarding to " + userName + "@" + hostName + " ports " + portLocal + " -> " + portRemote));
        }

        String getKey() {
            return PortForwardingServer.this.buildPfKey(this.hostName, this.userName);
        }

        void close() throws IOException {
            if (this.portForwarder != null) {
                this.portForwarder.close();
            }
            if (this.con != null) {
                this.con.close();
            }
        }
    }

    class MessageHandler
    implements Runnable {
        Socket socket;
        ConnectionR conR;
        boolean keepHandlerRunning;

        public MessageHandler(Socket socket) throws IOException {
            try {
                this.socket = socket;
                this.conR = new ConnectionR(socket);
            }
            catch (IOException iox) {
                this.closeCmdConnection();
                throw iox;
            }
        }

        @Override
        public void run() {
            this.keepHandlerRunning = true;
            while (this.keepHandlerRunning) {
                Message m = null;
                try {
                    m = this.conR.readMessage();
                    if (MessageType.cj.equals((Object)m.type)) {
                        AppCmd ac = new AppCmd(m.obj);
                        this.respondToCommand(ac);
                        continue;
                    }
                    this.conR.writeMessage(new Message(MessageType.er, "Incorrect message type= " + StringUtil.toStringNull((Object)m.type)));
                }
                catch (Exception xx) {
                    if (!(xx instanceof RReaderEOFException)) continue;
                    Verbose.show((String)"PortForwardingServer: Error reading client message", (Exception)xx);
                    this.closeCmdConnection();
                    return;
                }
            }
        }

        void respondToCommand(AppCmd ac) {
            try {
                Cmd c = Cmd.valueOf(ac.getCmdName());
                switch (c) {
                    case startPortForwarding: {
                        this.startPortForwarding(ac);
                        break;
                    }
                    case terminatePortForwarding: {
                        this.terminatePortForwarding(ac);
                        break;
                    }
                    case terminateAllPortForwarding: {
                        this.terminateAllPortForwarding();
                        break;
                    }
                    case closeCmdConnection: {
                        this.closeCmdConnection();
                        break;
                    }
                    case shutdown: {
                        this.shutdownApp();
                        break;
                    }
                    case test: {
                        this.test(ac);
                    }
                }
            }
            catch (IllegalArgumentException iax) {
                this.sendMessageToR("Undefined cmd=" + ac.getCmdName());
            }
            catch (Exception xxx) {
                this.sendErrMToR(xxx);
            }
        }

        void shutdownApp() {
            this.sendMessageToR("Shutting down the ssh portforwarding app; all portforwarding has been shutdown.");
            System.exit(0);
        }

        void test(AppCmd ac) {
            String mess = ac.getVal("message");
            System.err.println("TEST MESSAGE: " + mess);
            this.sendMessageToR("REPLY: " + mess);
        }

        void startPortForwarding(AppCmd ac) {
            try {
                String hostName = ac.getVal(PortForwardingServer.CMD_LABEL_HOST);
                String userName = ac.getVal(PortForwardingServer.CMD_LABEL_USER_NAME);
                File pemFile = new File(ac.getVal("pemfile"));
                int portLocal = Integer.parseInt(ac.getVal(PortForwardingServer.CMD_LABEL_PORT_LOCAL));
                int portRemote = Integer.parseInt(ac.getVal(PortForwardingServer.CMD_LABEL_PORT_REMOTE));
                if (!pemFile.exists()) {
                    this.sendMessageToR("PEM file " + pemFile.getPath() + " does not exist.");
                    return;
                }
                if (hostName == null || userName == null || portLocal <= 0 || portRemote <= 0) {
                    this.sendMessageToR("One or more bad params: host=" + hostName + " user=" + userName + " portremote=" + portRemote + " portlocal=" + portLocal);
                }
                if (PortForwardingServer.this.pfHt.containsKey(PortForwardingServer.this.buildPfKey(hostName, userName))) {
                    this.sendMessageToR(PortForwardingServer.this.buildPfKey(hostName, userName));
                } else {
                    if (this.portInUse(portLocal)) {
                        this.sendMessageToR("Local port " + Integer.toString(portLocal) + " is already being used.");
                    }
                    Pf pf = new Pf(hostName, userName, portRemote, pemFile, portLocal);
                    PortForwardingServer.this.pfHt.put(pf.getKey(), pf);
                    this.sendMessageToR(pf.getKey());
                }
            }
            catch (Exception xxx) {
                this.sendErrMToR(xxx);
            }
        }

        private boolean portInUse(int port) {
            if (port == 4470 || port == 4460 || port == 4464 || port == 4461) {
                return true;
            }
            for (Pf pf : PortForwardingServer.this.pfHt.values()) {
                if (pf.portLocal != port) continue;
                return true;
            }
            return false;
        }

        void terminatePortForwarding(AppCmd ac) {
            try {
                String hostName = ac.getVal(PortForwardingServer.CMD_LABEL_HOST);
                String userName = ac.getVal(PortForwardingServer.CMD_LABEL_USER_NAME);
                if (hostName == null || userName == null) {
                    this.sendMessageToR("One or more bad params: host=" + hostName + " user=" + userName);
                    return;
                }
                String key = PortForwardingServer.this.buildPfKey(hostName, userName);
                Pf pf = PortForwardingServer.this.pfHt.get(key);
                if (pf != null) {
                    pf.close();
                    PortForwardingServer.this.pfHt.remove(key);
                    this.sendMessageToR("Closed connection to " + key);
                } else {
                    this.sendMessageToR("No connection to " + key);
                }
            }
            catch (Exception xxx) {
                this.sendErrMToR(xxx);
            }
        }

        void terminateAllPortForwarding() {
            try {
                for (Pf pf : PortForwardingServer.this.pfHt.values()) {
                    pf.close();
                }
                PortForwardingServer.this.pfHt.clear();
                this.sendMessageToR("All port forwarding has been terminated.");
            }
            catch (Exception xxx) {
                this.sendErrMToR(xxx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeCmdConnection() {
            block7: {
                try {
                    if (this.conR != null) {
                        this.conR.close();
                    }
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (IOException iox) {
                    Verbose.show((Exception)iox);
                }
                finally {
                    this.keepHandlerRunning = false;
                    Iterator<MessageHandler> i$ = PortForwardingServer.this.messageHandlers.iterator();
                    if (!i$.hasNext()) break block7;
                    MessageHandler h = i$.next();
                    PortForwardingServer.this.messageHandlers.remove(h);
                    return;
                }
            }
        }

        protected void sendErrMToR(String m) {
            try {
                this.conR.writeMessage(new Message(MessageType.er, m));
                Verbose.show((String)("ClientCmdHandler sending error message to client failed: " + m));
            }
            catch (Exception z) {
                System.err.println(StringUtil.toString((Throwable)z));
            }
        }

        protected void sendErrMToR(Exception x) {
            this.sendErrMToR(StringUtil.getExceptionMessage((Throwable)x));
        }

        protected void sendErrMToR(String prefix, Exception x) {
            this.sendErrMToR(prefix + ": " + StringUtil.getExceptionMessage((Throwable)x) + "\n" + StringUtil.exceptionStackToString((Throwable)x));
        }

        protected void sendMessageToR(String m) {
            try {
                if (m == null || m.length() < 1) {
                    m = " ";
                }
                this.conR.writeMessage(new Message(MessageType.rj, m));
            }
            catch (Exception z) {
                System.err.println(StringUtil.toString((Throwable)z));
            }
        }
    }

    static enum Cmd {
        startPortForwarding,
        terminatePortForwarding,
        terminateAllPortForwarding,
        closeCmdConnection,
        shutdown,
        test;

    }
}

