/*
 * Decompiled with CFR 0.152.
 */
package rreval;

import com.norbl.util.StringUtil;
import java.io.File;
import java.net.Socket;
import rreval.AppCmd;
import rreval.ClientMessageHandler;
import rreval.ConnectionJ;
import rreval.ConnectionR;
import rreval.Message;
import rreval.MessageType;
import rreval.MessageWrangler;
import rreval.SshWrangler;
import rreval.Verbose;

public class ClientCmdHandler
extends MessageWrangler {
    public static final String TERMINAL_PREFIX = "TERMINAL RRE APP ERROR:";
    ClientMessageHandler parent;
    SshWrangler sshWrangler;

    public ClientCmdHandler(ConnectionR conR, ClientMessageHandler parent) {
        this.setConR(conR);
        this.parent = parent;
    }

    public void handleCmd(Message m) {
        try {
            AppCmd ac = new AppCmd(m.obj);
            Verbose.show("ClientCmdHandler app cmd=" + ac.toString());
            Cmd c = Cmd.valueOf(ac.cmdName);
            switch (c) {
                case connectToRReServer: {
                    this.connectToServer(ac);
                    break;
                }
                case uploadFile: {
                    this.uploadFile(ac);
                    break;
                }
                case downloadFile: {
                    this.downloadFile(ac);
                    break;
                }
                case closeConnection: {
                    this.closeConnection();
                    break;
                }
                case closeMessageHandler: {
                    this.closeMessageHandler();
                    break;
                }
                case testCmdClientApp: {
                    this.testCommandClient(ac);
                    break;
                }
                case testCmdServerApp: {
                    this.forwardMessage(m);
                    break;
                }
                case shutdown: {
                    this.shutdown();
                    break;
                }
            }
        }
        catch (Exception x) {
            Verbose.show("ClientCmdHandler.handleCmd(): ", x);
            this.sendErrMToR("ClientCmdHandler.handleCmd()", x);
        }
    }

    void forwardMessage(Message m) {
        try {
            this.conJ.writeMessage(m);
            this.conR.writeMessage((Message)this.conJ.readMessage());
        }
        catch (Exception x) {
            this.sendErrMToR("Error from forwarded message", x);
        }
    }

    void connectToServer(AppCmd ac) {
        try {
            ServerParams params = new ServerParams(ac);
            if (!params.isFullySpecified()) {
                Verbose.show("Params misspecified: " + params.getState());
                this.sendErrMToR(params.getState());
                return;
            }
            Verbose.show("connectToServer Params ok");
            if (this.parent.isConnectedToConduit()) {
                Verbose.show("Already connected.");
                this.sendErrMToR("This connection is already connected to rreval server " + params.userName + "@" + params.hostName);
                return;
            }
            this.sshWrangler = new SshWrangler(params.hostName, params.userName, params.pemFile, params.portJJ, params.portJJ);
            this.sshWrangler.startPortForwarding();
            Socket socketJ = new Socket("localhost", params.portJJ);
            Verbose.show("Connected to socket on " + params.hostName + "@" + params.userName + ":" + params.portJJ + " bound? " + socketJ.isBound());
            ConnectionJ cj = new ConnectionJ(socketJ, ConnectionJ.HostType.client);
            Verbose.show("Connected to the server app");
            try {
                cj.writeMessage(Message.createConnectToRReServerMessage());
                Verbose.show("... send connect cmd to the server app");
                Message reply = (Message)cj.readMessage();
                Verbose.show("Got reply from server app: " + reply.obj);
                if (reply.isNotAvailableMessage()) {
                    Verbose.show("Reply: not available, closing con to server app.");
                    this.closeConnectionToServerApp(cj);
                    Verbose.show("Closed con to server app");
                    this.sendErrMToR(reply.obj);
                    return;
                }
            }
            catch (Exception cx) {
                Verbose.show(cx);
                this.sendErrMToR(cx);
                this.closeConnectionToServerApp(cj);
                return;
            }
            this.parent.setConJs(cj);
            this.conR.writeMessage(new Message(MessageType.rj, "Connected to " + params.hostName + "@" + params.userName + ":" + Integer.toString(params.portJJ)));
            this.sshWrangler.setupScp();
        }
        catch (Exception x) {
            Verbose.show(x);
            String mess = TERMINAL_PREFIX + StringUtil.toString((Throwable)x);
            this.sendErrMToR(mess);
            this.parent.shutdown();
        }
    }

    void closeConnection(boolean callParentShutdown) {
        try {
            this.conJ.writeMessage(Message.createDisconnectFromClientMessage());
        }
        catch (Exception x) {
            System.err.println(StringUtil.toString((Throwable)x));
        }
        this.closeConnectionToServerApp(this.conJ);
        try {
            this.conR.writeMessage(new Message(MessageType.rj, "Shutting down connection to rreval server"));
        }
        catch (Exception x) {
            System.err.println(StringUtil.toString((Throwable)x));
        }
        if (callParentShutdown) {
            this.parent.shutdown();
        }
    }

    void closeConnection() {
        this.closeConnection(true);
    }

    void shutdown() {
        try {
            this.parent.parentApp.closeAllAndShutdown();
        }
        catch (Exception x) {
            System.exit(0);
        }
    }

    void closeConnectionToServerApp(ConnectionJ jcon) {
        try {
            if (this.sshWrangler != null) {
                this.sshWrangler.shutdown();
            }
        }
        catch (Exception x) {
            System.err.println(StringUtil.toString((Throwable)x));
        }
        try {
            jcon.close();
        }
        catch (Exception x) {
            System.err.println(StringUtil.toString((Throwable)x));
        }
    }

    void closeMessageHandler() {
        try {
            this.conR.writeMessage(new Message(MessageType.rj, "Closing message handler"));
        }
        catch (Exception x) {
            System.err.println(StringUtil.toString((Throwable)x));
        }
        this.parent.closeHandler();
    }

    void uploadFile(AppCmd ac) {
        if (this.sshWrangler == null) {
            this.sendErrMToR("ssh/scp is not connected.");
        } else {
            try {
                this.sendMessageToR(this.sshWrangler.scpUpload(ac));
            }
            catch (Exception xxx) {
                this.sendErrMToR("Error uploading file", xxx);
            }
        }
    }

    void downloadFile(AppCmd ac) {
        if (this.sshWrangler == null) {
            this.sendErrMToR("ssh/scp is not connected.");
        } else {
            try {
                this.sendMessageToR(this.sshWrangler.scpDownload(ac));
            }
            catch (Exception xxx) {
                this.sendErrMToR("Error downloading file", xxx);
            }
        }
    }

    void testCommandClient(AppCmd ac) throws Exception {
        Verbose.show("ClientCmdHandler got app cmd=" + ac.cmdName);
        this.conR.writeMessage(new Message(MessageType.rj, "Reply to test message from client app"));
    }

    void unimplemented(Cmd cmd) {
        try {
            this.conR.writeMessage(new Message(MessageType.rj, "Client app: Command " + cmd.toString() + " is not implemented yet."));
        }
        catch (Exception z) {
            Verbose.showStack("unimplemented", z);
            this.sendErrMToR("connectToServer()", z);
        }
    }

    class ServerParams {
        String hostName;
        String userName;
        int portRJ;
        int portJJ;
        File pemFile;

        ServerParams(AppCmd ac) {
            this.hostName = ac.getVal("hostName");
            this.userName = ac.getVal("userName");
            this.portRJ = this.getInt(ac.getVal("portRJ"));
            this.portJJ = this.getInt(ac.getVal("portJJ"));
            this.pemFile = new File(ac.getVal("pemFile"));
        }

        boolean isFullySpecified() {
            return this.hostName != null || this.userName != null || this.portRJ > 0 || this.portJJ > 0 && this.pemFile.exists();
        }

        String getState() {
            if (!this.isFullySpecified()) {
                StringBuilder s = new StringBuilder("rreval server params are not fully  specified: ");
                if (this.hostName == null) {
                    s.append("<null hostName> ");
                }
                if (this.userName == null) {
                    s.append("<null userName>");
                }
                if (this.portRJ < 0) {
                    s.append("<bad port number R <-> Java app> ");
                }
                if (this.portJJ < 0) {
                    s.append("<bad remote port number Java app <-> Java > ");
                }
                if (!this.pemFile.exists()) {
                    s.append("<pem file " + this.pemFile.getPath() + " does not exist> ");
                }
                return s.toString();
            }
            return "fully specified";
        }

        private int getInt(String s) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception x) {
                return -1;
            }
        }
    }

    static enum Cmd {
        connectToRReServer,
        closeConnection,
        closeMessageHandler,
        uploadFile,
        downloadFile,
        testCmdClientApp,
        testCmdServerApp,
        shutdown;

    }
}

