/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.norbl.util.ssh;

import com.norbl.util.gui.*;
import java.awt.event.*;
import javax.swing.text.*;
import javax.swing.*;

/**
 *
 * @author moi
 */
public class SshMinimalShellFrame extends javax.swing.JFrame {

    WevHandler wevh;
    SshMinimalShell parent;
    boolean disposed;
    
    /**
     * Creates new form SshMinimalShellFrame
     */
    public SshMinimalShellFrame(String hostName,
                                SshMinimalShell parent) {
        this.parent = parent;
        disposed = false;
        wevh = new WevHandler();
        this.addWindowListener(wevh);
        initComponents();
        SwingDefaults.setIcon(this);
        this.setTitle("ssh to " + hostName);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(1000 * 60 * 20);
        helpLabel.setToolTipText(SshMinimalShell.helpTT);
        setStdoutScrollDown();
        setStderrScrollDown();
        this.setVisible(true);
    }
    
    public void setStdoutScrollDown() {
        ((DefaultCaret) stdoutJJTextArea.getCaret()).setUpdatePolicy(
                                    DefaultCaret.ALWAYS_UPDATE);
    }
    
    public void setStderrScrollDown() {
        ((DefaultCaret) stderrJTextArea.getCaret()).setUpdatePolicy(
                                    DefaultCaret.ALWAYS_UPDATE);
    }
    
    public void appendOutput(String s) {
        stdoutJJTextArea.append(s);
    }
    
    public Document getStdinDoc() {
        return(stdinJTextArea.getDocument());
    }
    
    public void appendToStdin(String s) {
        stdinJTextArea.append(s);
    }
    
    public void setInputKeyListener(KeyListener kl) {
        stdinJTextArea.addKeyListener(kl);
    }
    
    class WevHandler extends WindowAdapter {        
        public void windowClosing(WindowEvent e) {        
            if ( !disposed ) {
                (new Thread() { public void run() {
                    if (parent != null) parent.shutdown();
                }}).start();
                SshMinimalShellFrame.this.dispose();
                disposed = true;
            }
        }
        public void windowClosed(WindowEvent e) {        
           if ( !disposed ) {
            (new Thread() { public void run() {
                    if (parent != null) parent.shutdown();
                }}).start();
                SshMinimalShellFrame.this.dispose();
                disposed = true;
           }
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        stderrSP = new javax.swing.JScrollPane();
        stderrJTextArea = new javax.swing.JTextArea();
        outputSP = new javax.swing.JScrollPane();
        stdoutJJTextArea = new javax.swing.JTextArea();
        inputSP = new javax.swing.JScrollPane();
        stdinJTextArea = new javax.swing.JTextArea();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        helpLabel = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);

        stderrJTextArea.setColumns(20);
        stderrJTextArea.setEditable(false);
        stderrJTextArea.setRows(5);
        stderrSP.setViewportView(stderrJTextArea);

        stdoutJJTextArea.setColumns(20);
        stdoutJJTextArea.setEditable(false);
        stdoutJJTextArea.setRows(5);
        outputSP.setViewportView(stdoutJJTextArea);

        stdinJTextArea.setColumns(20);
        stdinJTextArea.setRows(5);
        inputSP.setViewportView(stdinJTextArea);

        jLabel1.setFont(new java.awt.Font("DejaVu Sans", 1, 13)); // NOI18N
        jLabel1.setText("stderr");

        jLabel2.setFont(new java.awt.Font("DejaVu Sans", 1, 13)); // NOI18N
        jLabel2.setText("stdout");

        jLabel3.setFont(new java.awt.Font("DejaVu Sans", 1, 13)); // NOI18N
        jLabel3.setText("stdin");

        helpLabel.setText("help");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(stderrSP, javax.swing.GroupLayout.DEFAULT_SIZE, 595, Short.MAX_VALUE)
                    .addComponent(outputSP)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel2)
                            .addComponent(jLabel3))
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addComponent(inputSP)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(helpLabel)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(helpLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(stderrSP, javax.swing.GroupLayout.PREFERRED_SIZE, 77, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(outputSP, javax.swing.GroupLayout.PREFERRED_SIZE, 438, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(inputSP, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /*
         * Set the Nimbus look and feel
         */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /*
         * If Nimbus (introduced in Java SE 6) is not available, stay with the
         * default look and feel. For details see
         * http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(SshMinimalShellFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(SshMinimalShellFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(SshMinimalShellFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(SshMinimalShellFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /*
         * Create and display the form
//         */
//        java.awt.EventQueue.invokeLater(new Runnable() {
//
//            public void run() {
//                new SshMinimalShellFrame().setVisible(true);
//            }
//        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel helpLabel;
    private javax.swing.JScrollPane inputSP;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JScrollPane outputSP;
    private javax.swing.JTextArea stderrJTextArea;
    private javax.swing.JScrollPane stderrSP;
    private javax.swing.JTextArea stdinJTextArea;
    private javax.swing.JTextArea stdoutJJTextArea;
    // End of variables declaration//GEN-END:variables
}
