/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.S3Storage;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3StorageStaxUnmarshaller
implements Unmarshaller<S3Storage, StaxUnmarshallerContext> {
    private static S3StorageStaxUnmarshaller instance;

    @Override
    public S3Storage unmarshall(StaxUnmarshallerContext context) throws Exception {
        S3Storage s3Storage = new S3Storage();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return s3Storage;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("bucket", targetDepth)) {
                    s3Storage.setBucket(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("prefix", targetDepth)) {
                    s3Storage.setPrefix(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("awsAccessKeyId", targetDepth)) {
                    s3Storage.setAWSAccessKeyId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("uploadPolicy", targetDepth)) {
                    s3Storage.setUploadPolicy(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("uploadPolicySignature", targetDepth)) continue;
                s3Storage.setUploadPolicySignature(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return s3Storage;
    }

    public static S3StorageStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3StorageStaxUnmarshaller();
        }
        return instance;
    }
}

