/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddInstanceGroupsRequestMarshaller
implements Marshaller<Request<AddInstanceGroupsRequest>, AddInstanceGroupsRequest> {
    @Override
    public Request<AddInstanceGroupsRequest> marshall(AddInstanceGroupsRequest addInstanceGroupsRequest) {
        if (addInstanceGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddInstanceGroupsRequest> request = new DefaultRequest<AddInstanceGroupsRequest>(addInstanceGroupsRequest, "AmazonElasticMapReduce");
        request.addParameter("Action", "AddInstanceGroups");
        request.addParameter("Version", "2009-03-31");
        List<InstanceGroupConfig> instanceGroupsList = addInstanceGroupsRequest.getInstanceGroups();
        int instanceGroupsListIndex = 1;
        for (InstanceGroupConfig instanceGroupsListValue : instanceGroupsList) {
            InstanceGroupConfig instanceGroupConfigMember = instanceGroupsListValue;
            if (instanceGroupConfigMember != null) {
                if (instanceGroupConfigMember.getName() != null) {
                    request.addParameter("InstanceGroups.member." + instanceGroupsListIndex + ".Name", StringUtils.fromString(instanceGroupConfigMember.getName()));
                }
                if (instanceGroupConfigMember.getMarket() != null) {
                    request.addParameter("InstanceGroups.member." + instanceGroupsListIndex + ".Market", StringUtils.fromString(instanceGroupConfigMember.getMarket()));
                }
                if (instanceGroupConfigMember.getInstanceRole() != null) {
                    request.addParameter("InstanceGroups.member." + instanceGroupsListIndex + ".InstanceRole", StringUtils.fromString(instanceGroupConfigMember.getInstanceRole()));
                }
                if (instanceGroupConfigMember.getBidPrice() != null) {
                    request.addParameter("InstanceGroups.member." + instanceGroupsListIndex + ".BidPrice", StringUtils.fromString(instanceGroupConfigMember.getBidPrice()));
                }
                if (instanceGroupConfigMember.getInstanceType() != null) {
                    request.addParameter("InstanceGroups.member." + instanceGroupsListIndex + ".InstanceType", StringUtils.fromString(instanceGroupConfigMember.getInstanceType()));
                }
                if (instanceGroupConfigMember.getInstanceCount() != null) {
                    request.addParameter("InstanceGroups.member." + instanceGroupsListIndex + ".InstanceCount", StringUtils.fromInteger(instanceGroupConfigMember.getInstanceCount()));
                }
            }
            ++instanceGroupsListIndex;
        }
        if (addInstanceGroupsRequest.getJobFlowId() != null) {
            request.addParameter("JobFlowId", StringUtils.fromString(addInstanceGroupsRequest.getJobFlowId()));
        }
        return request;
    }
}

