% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clubSandwich.R
\name{vcovCR}
\alias{vcovCR}
\alias{vcovCR.default}
\title{Cluster-robust variance-covariance matrix}
\usage{
vcovCR(obj, cluster, type, target, inverse_var, form, ...)

\method{vcovCR}{default}(obj, cluster, type, target = NULL,
  inverse_var = FALSE, form = "sandwich", ...)
}
\arguments{
\item{obj}{Fitted model for which to calcualte the variance-covariance matrix}

\item{cluster}{Expression or vector indicating which observations belong to 
the same cluster. For some classes, the cluster will be detected 
automatically if not specified.}

\item{type}{Character string specifying which small-sample adjustment should 
be used.}

\item{target}{Optional matrix or vector describing the working 
variance-covariance model used to calculate the \code{CR2} and \code{CR4} 
adjustment matrices. If a vector, the target matrix is assumed to be 
diagonal. If not specified, \code{vcovCR} will attempt to infer a value.}

\item{inverse_var}{Optional logical indicating whether the weights used in 
fitting the model are inverse-variance. If not specified, \code{vcovCR} 
will attempt to infer a value.}

\item{form}{Controls the form of the returned matrix. The default 
\code{"sandwich"} will return the sandwich variance-covariance matrix. 
Alternately, setting \code{form = "meat"} will return only the meat of the 
sandwich and setting \code{form = B}, where \code{B} is a matrix of 
appropriate dimension, will return the sandwich variance-covariance matrix 
calculated using \code{B} as the bread.}

\item{...}{Additional arguments available for some classes of objects.}
}
\value{
An object of class \code{c("vcovCR","clubSandwich")}, which consists 
  of a matrix of the estimated variance of and covariances between the 
  regression coefficient estimates. The matrix has several attributes: 
  \describe{ \item{type}{indicates which small-sample adjustment was used} 
  \item{cluster}{contains the factor vector that defines independent 
  clusters} \item{bread}{contains the bread matrix} \item{v_scale}{constant 
  used in scaling the sandwich estimator} \item{est_mats}{contains a list of 
  estimating matrices used to calculate the sandwich estimator} 
  \item{adjustments}{contains a list of adjustment matrices used to calculate
  the sandwich estimator} \item{target}{contains the working 
  variance-covariance model used to calculate the adjustment matrices. This 
  is needed for calculating small-sample corrections for Wald tests.} }
}
\description{
This is a generic function, with specific methods defined for 
  \code{\link[stats]{lm}}, \code{\link[plm]{plm}}, \code{\link[nlme]{gls}}, 
  \code{\link[nlme]{lme}}, \code{\link[robumeta]{robu}}, 
  \code{\link[metafor]{rma.uni}}, and \code{\link[metafor]{rma.mv}} objects.

\code{vcovCR} returns a sandwich estimate of the variance-covariance matrix 
of a set of regression coefficient estimates.
}
\details{
\code{vcovCR} returns a sandwich estimate of the variance-covariance matrix 
of a set of regression coefficient estimates.
}
\seealso{
\code{\link{vcovCR.lm}}, \code{\link{vcovCR.plm}}, 
  \code{\link{vcovCR.gls}}, \code{\link{vcovCR.lme}}, 
  \code{\link{vcovCR.robu}}, \code{\link{vcovCR.rma.uni}}, 
  \code{\link{vcovCR.rma.mv}}
}

